/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.NotebookExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotebookExecutionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotebookExecutionSummary> {
    private static final SdkField<String> NOTEBOOK_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NotebookExecutionSummary.getter(NotebookExecutionSummary::notebookExecutionId)).setter(NotebookExecutionSummary.setter(Builder::notebookExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookExecutionId").build()}).build();
    private static final SdkField<String> EDITOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NotebookExecutionSummary.getter(NotebookExecutionSummary::editorId)).setter(NotebookExecutionSummary.setter(Builder::editorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EditorId").build()}).build();
    private static final SdkField<String> NOTEBOOK_EXECUTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NotebookExecutionSummary.getter(NotebookExecutionSummary::notebookExecutionName)).setter(NotebookExecutionSummary.setter(Builder::notebookExecutionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookExecutionName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NotebookExecutionSummary.getter(NotebookExecutionSummary::statusAsString)).setter(NotebookExecutionSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(NotebookExecutionSummary.getter(NotebookExecutionSummary::startTime)).setter(NotebookExecutionSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(NotebookExecutionSummary.getter(NotebookExecutionSummary::endTime)).setter(NotebookExecutionSummary.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_EXECUTION_ID_FIELD, EDITOR_ID_FIELD, NOTEBOOK_EXECUTION_NAME_FIELD, STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String notebookExecutionId;
    private final String editorId;
    private final String notebookExecutionName;
    private final String status;
    private final Instant startTime;
    private final Instant endTime;

    private NotebookExecutionSummary(BuilderImpl builder) {
        this.notebookExecutionId = builder.notebookExecutionId;
        this.editorId = builder.editorId;
        this.notebookExecutionName = builder.notebookExecutionName;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public String notebookExecutionId() {
        return this.notebookExecutionId;
    }

    public String editorId() {
        return this.editorId;
    }

    public String notebookExecutionName() {
        return this.notebookExecutionName;
    }

    public NotebookExecutionStatus status() {
        return NotebookExecutionStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.editorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookExecutionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotebookExecutionSummary)) {
            return false;
        }
        NotebookExecutionSummary other = (NotebookExecutionSummary)obj;
        return Objects.equals(this.notebookExecutionId(), other.notebookExecutionId()) && Objects.equals(this.editorId(), other.editorId()) && Objects.equals(this.notebookExecutionName(), other.notebookExecutionName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public String toString() {
        return ToString.builder((String)"NotebookExecutionSummary").add("NotebookExecutionId", (Object)this.notebookExecutionId()).add("EditorId", (Object)this.editorId()).add("NotebookExecutionName", (Object)this.notebookExecutionName()).add("Status", (Object)this.statusAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotebookExecutionId": {
                return Optional.ofNullable(clazz.cast(this.notebookExecutionId()));
            }
            case "EditorId": {
                return Optional.ofNullable(clazz.cast(this.editorId()));
            }
            case "NotebookExecutionName": {
                return Optional.ofNullable(clazz.cast(this.notebookExecutionName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotebookExecutionSummary, T> g) {
        return obj -> g.apply((NotebookExecutionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String notebookExecutionId;
        private String editorId;
        private String notebookExecutionName;
        private String status;
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(NotebookExecutionSummary model) {
            this.notebookExecutionId(model.notebookExecutionId);
            this.editorId(model.editorId);
            this.notebookExecutionName(model.notebookExecutionName);
            this.status(model.status);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final String getNotebookExecutionId() {
            return this.notebookExecutionId;
        }

        @Override
        public final Builder notebookExecutionId(String notebookExecutionId) {
            this.notebookExecutionId = notebookExecutionId;
            return this;
        }

        public final void setNotebookExecutionId(String notebookExecutionId) {
            this.notebookExecutionId = notebookExecutionId;
        }

        public final String getEditorId() {
            return this.editorId;
        }

        @Override
        public final Builder editorId(String editorId) {
            this.editorId = editorId;
            return this;
        }

        public final void setEditorId(String editorId) {
            this.editorId = editorId;
        }

        public final String getNotebookExecutionName() {
            return this.notebookExecutionName;
        }

        @Override
        public final Builder notebookExecutionName(String notebookExecutionName) {
            this.notebookExecutionName = notebookExecutionName;
            return this;
        }

        public final void setNotebookExecutionName(String notebookExecutionName) {
            this.notebookExecutionName = notebookExecutionName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NotebookExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public NotebookExecutionSummary build() {
            return new NotebookExecutionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotebookExecutionSummary> {
        public Builder notebookExecutionId(String var1);

        public Builder editorId(String var1);

        public Builder notebookExecutionName(String var1);

        public Builder status(String var1);

        public Builder status(NotebookExecutionStatus var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

