/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EmrResponse;
import software.amazon.awssdk.services.emr.model.InstanceGroupIdsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddInstanceGroupsResponse
extends EmrResponse
implements ToCopyableBuilder<Builder, AddInstanceGroupsResponse> {
    private static final SdkField<String> JOB_FLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AddInstanceGroupsResponse.getter(AddInstanceGroupsResponse::jobFlowId)).setter(AddInstanceGroupsResponse.setter(Builder::jobFlowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobFlowId").build()}).build();
    private static final SdkField<List<String>> INSTANCE_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AddInstanceGroupsResponse.getter(AddInstanceGroupsResponse::instanceGroupIds)).setter(AddInstanceGroupsResponse.setter(Builder::instanceGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AddInstanceGroupsResponse.getter(AddInstanceGroupsResponse::clusterArn)).setter(AddInstanceGroupsResponse.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_FLOW_ID_FIELD, INSTANCE_GROUP_IDS_FIELD, CLUSTER_ARN_FIELD));
    private final String jobFlowId;
    private final List<String> instanceGroupIds;
    private final String clusterArn;

    private AddInstanceGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.jobFlowId = builder.jobFlowId;
        this.instanceGroupIds = builder.instanceGroupIds;
        this.clusterArn = builder.clusterArn;
    }

    public String jobFlowId() {
        return this.jobFlowId;
    }

    public boolean hasInstanceGroupIds() {
        return this.instanceGroupIds != null && !(this.instanceGroupIds instanceof SdkAutoConstructList);
    }

    public List<String> instanceGroupIds() {
        return this.instanceGroupIds;
    }

    public String clusterArn() {
        return this.clusterArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddInstanceGroupsResponse)) {
            return false;
        }
        AddInstanceGroupsResponse other = (AddInstanceGroupsResponse)((Object)obj);
        return Objects.equals(this.jobFlowId(), other.jobFlowId()) && Objects.equals(this.instanceGroupIds(), other.instanceGroupIds()) && Objects.equals(this.clusterArn(), other.clusterArn());
    }

    public String toString() {
        return ToString.builder((String)"AddInstanceGroupsResponse").add("JobFlowId", (Object)this.jobFlowId()).add("InstanceGroupIds", this.instanceGroupIds()).add("ClusterArn", (Object)this.clusterArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobFlowId": {
                return Optional.ofNullable(clazz.cast(this.jobFlowId()));
            }
            case "InstanceGroupIds": {
                return Optional.ofNullable(clazz.cast(this.instanceGroupIds()));
            }
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddInstanceGroupsResponse, T> g) {
        return obj -> g.apply((AddInstanceGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrResponse.BuilderImpl
    implements Builder {
        private String jobFlowId;
        private List<String> instanceGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String clusterArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AddInstanceGroupsResponse model) {
            super(model);
            this.jobFlowId(model.jobFlowId);
            this.instanceGroupIds(model.instanceGroupIds);
            this.clusterArn(model.clusterArn);
        }

        public final String getJobFlowId() {
            return this.jobFlowId;
        }

        @Override
        public final Builder jobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
            return this;
        }

        public final void setJobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
        }

        public final Collection<String> getInstanceGroupIds() {
            return this.instanceGroupIds;
        }

        @Override
        public final Builder instanceGroupIds(Collection<String> instanceGroupIds) {
            this.instanceGroupIds = InstanceGroupIdsListCopier.copy(instanceGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroupIds(String ... instanceGroupIds) {
            this.instanceGroupIds(Arrays.asList(instanceGroupIds));
            return this;
        }

        public final void setInstanceGroupIds(Collection<String> instanceGroupIds) {
            this.instanceGroupIds = InstanceGroupIdsListCopier.copy(instanceGroupIds);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public AddInstanceGroupsResponse build() {
            return new AddInstanceGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddInstanceGroupsResponse> {
        public Builder jobFlowId(String var1);

        public Builder instanceGroupIds(Collection<String> var1);

        public Builder instanceGroupIds(String ... var1);

        public Builder clusterArn(String var1);
    }
}

