/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to the <a>TerminateJobFlows</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TerminateJobFlowsRequest extends EmrRequest implements
        ToCopyableBuilder<TerminateJobFlowsRequest.Builder, TerminateJobFlowsRequest> {
    private static final SdkField<List<String>> JOB_FLOW_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(TerminateJobFlowsRequest::jobFlowIds))
            .setter(setter(Builder::jobFlowIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobFlowIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_FLOW_IDS_FIELD));

    private final List<String> jobFlowIds;

    private TerminateJobFlowsRequest(BuilderImpl builder) {
        super(builder);
        this.jobFlowIds = builder.jobFlowIds;
    }

    /**
     * Returns true if the JobFlowIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasJobFlowIds() {
        return jobFlowIds != null && !(jobFlowIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of job flows to be shutdown.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasJobFlowIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of job flows to be shutdown.
     */
    public List<String> jobFlowIds() {
        return jobFlowIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobFlowIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateJobFlowsRequest)) {
            return false;
        }
        TerminateJobFlowsRequest other = (TerminateJobFlowsRequest) obj;
        return Objects.equals(jobFlowIds(), other.jobFlowIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TerminateJobFlowsRequest").add("JobFlowIds", jobFlowIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobFlowIds":
            return Optional.ofNullable(clazz.cast(jobFlowIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TerminateJobFlowsRequest, T> g) {
        return obj -> g.apply((TerminateJobFlowsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrRequest.Builder, SdkPojo, CopyableBuilder<Builder, TerminateJobFlowsRequest> {
        /**
         * <p>
         * A list of job flows to be shutdown.
         * </p>
         * 
         * @param jobFlowIds
         *        A list of job flows to be shutdown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobFlowIds(Collection<String> jobFlowIds);

        /**
         * <p>
         * A list of job flows to be shutdown.
         * </p>
         * 
         * @param jobFlowIds
         *        A list of job flows to be shutdown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobFlowIds(String... jobFlowIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrRequest.BuilderImpl implements Builder {
        private List<String> jobFlowIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateJobFlowsRequest model) {
            super(model);
            jobFlowIds(model.jobFlowIds);
        }

        public final Collection<String> getJobFlowIds() {
            return jobFlowIds;
        }

        @Override
        public final Builder jobFlowIds(Collection<String> jobFlowIds) {
            this.jobFlowIds = XmlStringListCopier.copy(jobFlowIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobFlowIds(String... jobFlowIds) {
            jobFlowIds(Arrays.asList(jobFlowIds));
            return this;
        }

        public final void setJobFlowIds(Collection<String> jobFlowIds) {
            this.jobFlowIds = XmlStringListCopier.copy(jobFlowIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TerminateJobFlowsRequest build() {
            return new TerminateJobFlowsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
