/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This input determines how the ListClusters action filters the list of clusters that it returns.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListClustersRequest extends EmrRequest implements
        ToCopyableBuilder<ListClustersRequest.Builder, ListClustersRequest> {
    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListClustersRequest::createdAfter)).setter(setter(Builder::createdAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAfter").build()).build();

    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListClustersRequest::createdBefore)).setter(setter(Builder::createdBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBefore").build()).build();

    private static final SdkField<List<String>> CLUSTER_STATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListClustersRequest::clusterStatesAsStrings))
            .setter(setter(Builder::clusterStatesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterStates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListClustersRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AFTER_FIELD,
            CREATED_BEFORE_FIELD, CLUSTER_STATES_FIELD, MARKER_FIELD));

    private final Instant createdAfter;

    private final Instant createdBefore;

    private final List<String> clusterStates;

    private final String marker;

    private ListClustersRequest(BuilderImpl builder) {
        super(builder);
        this.createdAfter = builder.createdAfter;
        this.createdBefore = builder.createdBefore;
        this.clusterStates = builder.clusterStates;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The creation date and time beginning value filter for listing clusters.
     * </p>
     * 
     * @return The creation date and time beginning value filter for listing clusters.
     */
    public Instant createdAfter() {
        return createdAfter;
    }

    /**
     * <p>
     * The creation date and time end value filter for listing clusters.
     * </p>
     * 
     * @return The creation date and time end value filter for listing clusters.
     */
    public Instant createdBefore() {
        return createdBefore;
    }

    /**
     * <p>
     * The cluster state filters to apply when listing clusters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasClusterStates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The cluster state filters to apply when listing clusters.
     */
    public List<ClusterState> clusterStates() {
        return ClusterStateListCopier.copyStringToEnum(clusterStates);
    }

    /**
     * Returns true if the ClusterStates property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasClusterStates() {
        return clusterStates != null && !(clusterStates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The cluster state filters to apply when listing clusters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasClusterStates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The cluster state filters to apply when listing clusters.
     */
    public List<String> clusterStatesAsStrings() {
        return clusterStates;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results to retrieve.
     */
    public String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(clusterStatesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersRequest)) {
            return false;
        }
        ListClustersRequest other = (ListClustersRequest) obj;
        return Objects.equals(createdAfter(), other.createdAfter()) && Objects.equals(createdBefore(), other.createdBefore())
                && Objects.equals(clusterStatesAsStrings(), other.clusterStatesAsStrings())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListClustersRequest").add("CreatedAfter", createdAfter()).add("CreatedBefore", createdBefore())
                .add("ClusterStates", clusterStatesAsStrings()).add("Marker", marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedAfter":
            return Optional.ofNullable(clazz.cast(createdAfter()));
        case "CreatedBefore":
            return Optional.ofNullable(clazz.cast(createdBefore()));
        case "ClusterStates":
            return Optional.ofNullable(clazz.cast(clusterStatesAsStrings()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListClustersRequest, T> g) {
        return obj -> g.apply((ListClustersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListClustersRequest> {
        /**
         * <p>
         * The creation date and time beginning value filter for listing clusters.
         * </p>
         * 
         * @param createdAfter
         *        The creation date and time beginning value filter for listing clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAfter(Instant createdAfter);

        /**
         * <p>
         * The creation date and time end value filter for listing clusters.
         * </p>
         * 
         * @param createdBefore
         *        The creation date and time end value filter for listing clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBefore(Instant createdBefore);

        /**
         * <p>
         * The cluster state filters to apply when listing clusters.
         * </p>
         * 
         * @param clusterStates
         *        The cluster state filters to apply when listing clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterStatesWithStrings(Collection<String> clusterStates);

        /**
         * <p>
         * The cluster state filters to apply when listing clusters.
         * </p>
         * 
         * @param clusterStates
         *        The cluster state filters to apply when listing clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterStatesWithStrings(String... clusterStates);

        /**
         * <p>
         * The cluster state filters to apply when listing clusters.
         * </p>
         * 
         * @param clusterStates
         *        The cluster state filters to apply when listing clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterStates(Collection<ClusterState> clusterStates);

        /**
         * <p>
         * The cluster state filters to apply when listing clusters.
         * </p>
         * 
         * @param clusterStates
         *        The cluster state filters to apply when listing clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterStates(ClusterState... clusterStates);

        /**
         * <p>
         * The pagination token that indicates the next set of results to retrieve.
         * </p>
         * 
         * @param marker
         *        The pagination token that indicates the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrRequest.BuilderImpl implements Builder {
        private Instant createdAfter;

        private Instant createdBefore;

        private List<String> clusterStates = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClustersRequest model) {
            super(model);
            createdAfter(model.createdAfter);
            createdBefore(model.createdBefore);
            clusterStatesWithStrings(model.clusterStates);
            marker(model.marker);
        }

        public final Instant getCreatedAfter() {
            return createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        public final Instant getCreatedBefore() {
            return createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        public final Collection<String> getClusterStates() {
            return clusterStates;
        }

        @Override
        public final Builder clusterStatesWithStrings(Collection<String> clusterStates) {
            this.clusterStates = ClusterStateListCopier.copy(clusterStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterStatesWithStrings(String... clusterStates) {
            clusterStatesWithStrings(Arrays.asList(clusterStates));
            return this;
        }

        @Override
        public final Builder clusterStates(Collection<ClusterState> clusterStates) {
            this.clusterStates = ClusterStateListCopier.copyEnumToString(clusterStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterStates(ClusterState... clusterStates) {
            clusterStates(Arrays.asList(clusterStates));
            return this;
        }

        public final void setClusterStates(Collection<String> clusterStates) {
            this.clusterStates = ClusterStateListCopier.copy(clusterStates);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListClustersRequest build() {
            return new ListClustersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
