/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration. For
 * more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos
 * Authentication</a> in the <i>EMR Management Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KerberosAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<KerberosAttributes.Builder, KerberosAttributes> {
    private static final SdkField<String> REALM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(KerberosAttributes::realm)).setter(setter(Builder::realm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Realm").build()).build();

    private static final SdkField<String> KDC_ADMIN_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(KerberosAttributes::kdcAdminPassword)).setter(setter(Builder::kdcAdminPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KdcAdminPassword").build()).build();

    private static final SdkField<String> CROSS_REALM_TRUST_PRINCIPAL_PASSWORD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(KerberosAttributes::crossRealmTrustPrincipalPassword))
            .setter(setter(Builder::crossRealmTrustPrincipalPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossRealmTrustPrincipalPassword")
                    .build()).build();

    private static final SdkField<String> AD_DOMAIN_JOIN_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(KerberosAttributes::adDomainJoinUser)).setter(setter(Builder::adDomainJoinUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ADDomainJoinUser").build()).build();

    private static final SdkField<String> AD_DOMAIN_JOIN_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(KerberosAttributes::adDomainJoinPassword)).setter(setter(Builder::adDomainJoinPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ADDomainJoinPassword").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REALM_FIELD,
            KDC_ADMIN_PASSWORD_FIELD, CROSS_REALM_TRUST_PRINCIPAL_PASSWORD_FIELD, AD_DOMAIN_JOIN_USER_FIELD,
            AD_DOMAIN_JOIN_PASSWORD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String realm;

    private final String kdcAdminPassword;

    private final String crossRealmTrustPrincipalPassword;

    private final String adDomainJoinUser;

    private final String adDomainJoinPassword;

    private KerberosAttributes(BuilderImpl builder) {
        this.realm = builder.realm;
        this.kdcAdminPassword = builder.kdcAdminPassword;
        this.crossRealmTrustPrincipalPassword = builder.crossRealmTrustPrincipalPassword;
        this.adDomainJoinUser = builder.adDomainJoinUser;
        this.adDomainJoinPassword = builder.adDomainJoinPassword;
    }

    /**
     * <p>
     * The name of the Kerberos realm to which all nodes in a cluster belong. For example, <code>EC2.INTERNAL</code>.
     * </p>
     * 
     * @return The name of the Kerberos realm to which all nodes in a cluster belong. For example,
     *         <code>EC2.INTERNAL</code>.
     */
    public String realm() {
        return realm;
    }

    /**
     * <p>
     * The password used within the cluster for the kadmin service on the cluster-dedicated KDC, which maintains
     * Kerberos principals, password policies, and keytabs for the cluster.
     * </p>
     * 
     * @return The password used within the cluster for the kadmin service on the cluster-dedicated KDC, which maintains
     *         Kerberos principals, password policies, and keytabs for the cluster.
     */
    public String kdcAdminPassword() {
        return kdcAdminPassword;
    }

    /**
     * <p>
     * Required only when establishing a cross-realm trust with a KDC in a different realm. The cross-realm principal
     * password, which must be identical across realms.
     * </p>
     * 
     * @return Required only when establishing a cross-realm trust with a KDC in a different realm. The cross-realm
     *         principal password, which must be identical across realms.
     */
    public String crossRealmTrustPrincipalPassword() {
        return crossRealmTrustPrincipalPassword;
    }

    /**
     * <p>
     * Required only when establishing a cross-realm trust with an Active Directory domain. A user with sufficient
     * privileges to join resources to the domain.
     * </p>
     * 
     * @return Required only when establishing a cross-realm trust with an Active Directory domain. A user with
     *         sufficient privileges to join resources to the domain.
     */
    public String adDomainJoinUser() {
        return adDomainJoinUser;
    }

    /**
     * <p>
     * The Active Directory password for <code>ADDomainJoinUser</code>.
     * </p>
     * 
     * @return The Active Directory password for <code>ADDomainJoinUser</code>.
     */
    public String adDomainJoinPassword() {
        return adDomainJoinPassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(realm());
        hashCode = 31 * hashCode + Objects.hashCode(kdcAdminPassword());
        hashCode = 31 * hashCode + Objects.hashCode(crossRealmTrustPrincipalPassword());
        hashCode = 31 * hashCode + Objects.hashCode(adDomainJoinUser());
        hashCode = 31 * hashCode + Objects.hashCode(adDomainJoinPassword());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KerberosAttributes)) {
            return false;
        }
        KerberosAttributes other = (KerberosAttributes) obj;
        return Objects.equals(realm(), other.realm()) && Objects.equals(kdcAdminPassword(), other.kdcAdminPassword())
                && Objects.equals(crossRealmTrustPrincipalPassword(), other.crossRealmTrustPrincipalPassword())
                && Objects.equals(adDomainJoinUser(), other.adDomainJoinUser())
                && Objects.equals(adDomainJoinPassword(), other.adDomainJoinPassword());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("KerberosAttributes").add("Realm", realm()).add("KdcAdminPassword", kdcAdminPassword())
                .add("CrossRealmTrustPrincipalPassword", crossRealmTrustPrincipalPassword())
                .add("ADDomainJoinUser", adDomainJoinUser()).add("ADDomainJoinPassword", adDomainJoinPassword()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Realm":
            return Optional.ofNullable(clazz.cast(realm()));
        case "KdcAdminPassword":
            return Optional.ofNullable(clazz.cast(kdcAdminPassword()));
        case "CrossRealmTrustPrincipalPassword":
            return Optional.ofNullable(clazz.cast(crossRealmTrustPrincipalPassword()));
        case "ADDomainJoinUser":
            return Optional.ofNullable(clazz.cast(adDomainJoinUser()));
        case "ADDomainJoinPassword":
            return Optional.ofNullable(clazz.cast(adDomainJoinPassword()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KerberosAttributes, T> g) {
        return obj -> g.apply((KerberosAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KerberosAttributes> {
        /**
         * <p>
         * The name of the Kerberos realm to which all nodes in a cluster belong. For example, <code>EC2.INTERNAL</code>
         * .
         * </p>
         * 
         * @param realm
         *        The name of the Kerberos realm to which all nodes in a cluster belong. For example,
         *        <code>EC2.INTERNAL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder realm(String realm);

        /**
         * <p>
         * The password used within the cluster for the kadmin service on the cluster-dedicated KDC, which maintains
         * Kerberos principals, password policies, and keytabs for the cluster.
         * </p>
         * 
         * @param kdcAdminPassword
         *        The password used within the cluster for the kadmin service on the cluster-dedicated KDC, which
         *        maintains Kerberos principals, password policies, and keytabs for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kdcAdminPassword(String kdcAdminPassword);

        /**
         * <p>
         * Required only when establishing a cross-realm trust with a KDC in a different realm. The cross-realm
         * principal password, which must be identical across realms.
         * </p>
         * 
         * @param crossRealmTrustPrincipalPassword
         *        Required only when establishing a cross-realm trust with a KDC in a different realm. The cross-realm
         *        principal password, which must be identical across realms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossRealmTrustPrincipalPassword(String crossRealmTrustPrincipalPassword);

        /**
         * <p>
         * Required only when establishing a cross-realm trust with an Active Directory domain. A user with sufficient
         * privileges to join resources to the domain.
         * </p>
         * 
         * @param adDomainJoinUser
         *        Required only when establishing a cross-realm trust with an Active Directory domain. A user with
         *        sufficient privileges to join resources to the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adDomainJoinUser(String adDomainJoinUser);

        /**
         * <p>
         * The Active Directory password for <code>ADDomainJoinUser</code>.
         * </p>
         * 
         * @param adDomainJoinPassword
         *        The Active Directory password for <code>ADDomainJoinUser</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adDomainJoinPassword(String adDomainJoinPassword);
    }

    static final class BuilderImpl implements Builder {
        private String realm;

        private String kdcAdminPassword;

        private String crossRealmTrustPrincipalPassword;

        private String adDomainJoinUser;

        private String adDomainJoinPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(KerberosAttributes model) {
            realm(model.realm);
            kdcAdminPassword(model.kdcAdminPassword);
            crossRealmTrustPrincipalPassword(model.crossRealmTrustPrincipalPassword);
            adDomainJoinUser(model.adDomainJoinUser);
            adDomainJoinPassword(model.adDomainJoinPassword);
        }

        public final String getRealm() {
            return realm;
        }

        @Override
        public final Builder realm(String realm) {
            this.realm = realm;
            return this;
        }

        public final void setRealm(String realm) {
            this.realm = realm;
        }

        public final String getKdcAdminPassword() {
            return kdcAdminPassword;
        }

        @Override
        public final Builder kdcAdminPassword(String kdcAdminPassword) {
            this.kdcAdminPassword = kdcAdminPassword;
            return this;
        }

        public final void setKdcAdminPassword(String kdcAdminPassword) {
            this.kdcAdminPassword = kdcAdminPassword;
        }

        public final String getCrossRealmTrustPrincipalPassword() {
            return crossRealmTrustPrincipalPassword;
        }

        @Override
        public final Builder crossRealmTrustPrincipalPassword(String crossRealmTrustPrincipalPassword) {
            this.crossRealmTrustPrincipalPassword = crossRealmTrustPrincipalPassword;
            return this;
        }

        public final void setCrossRealmTrustPrincipalPassword(String crossRealmTrustPrincipalPassword) {
            this.crossRealmTrustPrincipalPassword = crossRealmTrustPrincipalPassword;
        }

        public final String getAdDomainJoinUser() {
            return adDomainJoinUser;
        }

        @Override
        public final Builder adDomainJoinUser(String adDomainJoinUser) {
            this.adDomainJoinUser = adDomainJoinUser;
            return this;
        }

        public final void setAdDomainJoinUser(String adDomainJoinUser) {
            this.adDomainJoinUser = adDomainJoinUser;
        }

        public final String getAdDomainJoinPassword() {
            return adDomainJoinPassword;
        }

        @Override
        public final Builder adDomainJoinPassword(String adDomainJoinPassword) {
            this.adDomainJoinPassword = adDomainJoinPassword;
            return this;
        }

        public final void setAdDomainJoinPassword(String adDomainJoinPassword) {
            this.adDomainJoinPassword = adDomainJoinPassword;
        }

        @Override
        public KerberosAttributes build() {
            return new KerberosAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
