/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The instance status details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceStatus implements SdkPojo, Serializable, ToCopyableBuilder<InstanceStatus.Builder, InstanceStatus> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InstanceStatus::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<InstanceStateChangeReason> STATE_CHANGE_REASON_FIELD = SdkField
            .<InstanceStateChangeReason> builder(MarshallingType.SDK_POJO).getter(getter(InstanceStatus::stateChangeReason))
            .setter(setter(Builder::stateChangeReason)).constructor(InstanceStateChangeReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateChangeReason").build()).build();

    private static final SdkField<InstanceTimeline> TIMELINE_FIELD = SdkField
            .<InstanceTimeline> builder(MarshallingType.SDK_POJO).getter(getter(InstanceStatus::timeline))
            .setter(setter(Builder::timeline)).constructor(InstanceTimeline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeline").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD,
            STATE_CHANGE_REASON_FIELD, TIMELINE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String state;

    private final InstanceStateChangeReason stateChangeReason;

    private final InstanceTimeline timeline;

    private InstanceStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
        this.timeline = builder.timeline;
    }

    /**
     * <p>
     * The current state of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link InstanceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the instance.
     * @see InstanceState
     */
    public InstanceState state() {
        return InstanceState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link InstanceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the instance.
     * @see InstanceState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The details of the status change reason for the instance.
     * </p>
     * 
     * @return The details of the status change reason for the instance.
     */
    public InstanceStateChangeReason stateChangeReason() {
        return stateChangeReason;
    }

    /**
     * <p>
     * The timeline of the instance status over time.
     * </p>
     * 
     * @return The timeline of the instance status over time.
     */
    public InstanceTimeline timeline() {
        return timeline;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(timeline());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStatus)) {
            return false;
        }
        InstanceStatus other = (InstanceStatus) obj;
        return Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(stateChangeReason(), other.stateChangeReason()) && Objects.equals(timeline(), other.timeline());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InstanceStatus").add("State", stateAsString()).add("StateChangeReason", stateChangeReason())
                .add("Timeline", timeline()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateChangeReason":
            return Optional.ofNullable(clazz.cast(stateChangeReason()));
        case "Timeline":
            return Optional.ofNullable(clazz.cast(timeline()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceStatus, T> g) {
        return obj -> g.apply((InstanceStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceStatus> {
        /**
         * <p>
         * The current state of the instance.
         * </p>
         * 
         * @param state
         *        The current state of the instance.
         * @see InstanceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the instance.
         * </p>
         * 
         * @param state
         *        The current state of the instance.
         * @see InstanceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceState
         */
        Builder state(InstanceState state);

        /**
         * <p>
         * The details of the status change reason for the instance.
         * </p>
         * 
         * @param stateChangeReason
         *        The details of the status change reason for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateChangeReason(InstanceStateChangeReason stateChangeReason);

        /**
         * <p>
         * The details of the status change reason for the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceStateChangeReason.Builder} avoiding the
         * need to create one manually via {@link InstanceStateChangeReason#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceStateChangeReason.Builder#build()} is called immediately
         * and its result is passed to {@link #stateChangeReason(InstanceStateChangeReason)}.
         * 
         * @param stateChangeReason
         *        a consumer that will call methods on {@link InstanceStateChangeReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateChangeReason(InstanceStateChangeReason)
         */
        default Builder stateChangeReason(Consumer<InstanceStateChangeReason.Builder> stateChangeReason) {
            return stateChangeReason(InstanceStateChangeReason.builder().applyMutation(stateChangeReason).build());
        }

        /**
         * <p>
         * The timeline of the instance status over time.
         * </p>
         * 
         * @param timeline
         *        The timeline of the instance status over time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeline(InstanceTimeline timeline);

        /**
         * <p>
         * The timeline of the instance status over time.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceTimeline.Builder} avoiding the need to
         * create one manually via {@link InstanceTimeline#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceTimeline.Builder#build()} is called immediately and its
         * result is passed to {@link #timeline(InstanceTimeline)}.
         * 
         * @param timeline
         *        a consumer that will call methods on {@link InstanceTimeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeline(InstanceTimeline)
         */
        default Builder timeline(Consumer<InstanceTimeline.Builder> timeline) {
            return timeline(InstanceTimeline.builder().applyMutation(timeline).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private InstanceStateChangeReason stateChangeReason;

        private InstanceTimeline timeline;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStatus model) {
            state(model.state);
            stateChangeReason(model.stateChangeReason);
            timeline(model.timeline);
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(InstanceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final InstanceStateChangeReason.Builder getStateChangeReason() {
            return stateChangeReason != null ? stateChangeReason.toBuilder() : null;
        }

        @Override
        public final Builder stateChangeReason(InstanceStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final void setStateChangeReason(InstanceStateChangeReason.BuilderImpl stateChangeReason) {
            this.stateChangeReason = stateChangeReason != null ? stateChangeReason.build() : null;
        }

        public final InstanceTimeline.Builder getTimeline() {
            return timeline != null ? timeline.toBuilder() : null;
        }

        @Override
        public final Builder timeline(InstanceTimeline timeline) {
            this.timeline = timeline;
            return this;
        }

        public final void setTimeline(InstanceTimeline.BuilderImpl timeline) {
            this.timeline = timeline != null ? timeline.build() : null;
        }

        @Override
        public InstanceStatus build() {
            return new InstanceStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
