/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The EC2 unit limits for a managed scaling policy. The managed scaling activity of a cluster can not be above or below
 * these limits. The limit only applies to the core and task nodes. The master node cannot be scaled after initial
 * configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputeLimits implements SdkPojo, Serializable, ToCopyableBuilder<ComputeLimits.Builder, ComputeLimits> {
    private static final SdkField<String> UNIT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ComputeLimits::unitTypeAsString)).setter(setter(Builder::unitType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnitType").build()).build();

    private static final SdkField<Integer> MINIMUM_CAPACITY_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ComputeLimits::minimumCapacityUnits)).setter(setter(Builder::minimumCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumCapacityUnits").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_CAPACITY_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ComputeLimits::maximumCapacityUnits)).setter(setter(Builder::maximumCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumCapacityUnits").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_ON_DEMAND_CAPACITY_UNITS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ComputeLimits::maximumOnDemandCapacityUnits))
            .setter(setter(Builder::maximumOnDemandCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumOnDemandCapacityUnits")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNIT_TYPE_FIELD,
            MINIMUM_CAPACITY_UNITS_FIELD, MAXIMUM_CAPACITY_UNITS_FIELD, MAXIMUM_ON_DEMAND_CAPACITY_UNITS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String unitType;

    private final Integer minimumCapacityUnits;

    private final Integer maximumCapacityUnits;

    private final Integer maximumOnDemandCapacityUnits;

    private ComputeLimits(BuilderImpl builder) {
        this.unitType = builder.unitType;
        this.minimumCapacityUnits = builder.minimumCapacityUnits;
        this.maximumCapacityUnits = builder.maximumCapacityUnits;
        this.maximumOnDemandCapacityUnits = builder.maximumOnDemandCapacityUnits;
    }

    /**
     * <p>
     * The unit type used for specifying a managed scaling policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unitType} will
     * return {@link ComputeLimitsUnitType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #unitTypeAsString}.
     * </p>
     * 
     * @return The unit type used for specifying a managed scaling policy.
     * @see ComputeLimitsUnitType
     */
    public ComputeLimitsUnitType unitType() {
        return ComputeLimitsUnitType.fromValue(unitType);
    }

    /**
     * <p>
     * The unit type used for specifying a managed scaling policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unitType} will
     * return {@link ComputeLimitsUnitType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #unitTypeAsString}.
     * </p>
     * 
     * @return The unit type used for specifying a managed scaling policy.
     * @see ComputeLimitsUnitType
     */
    public String unitTypeAsString() {
        return unitType;
    }

    /**
     * <p>
     * The lower boundary of EC2 units. It is measured through VCPU cores or instances for instance groups and measured
     * through units for instance fleets. Managed scaling activities are not allowed beyond this boundary. The limit
     * only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
     * </p>
     * 
     * @return The lower boundary of EC2 units. It is measured through VCPU cores or instances for instance groups and
     *         measured through units for instance fleets. Managed scaling activities are not allowed beyond this
     *         boundary. The limit only applies to the core and task nodes. The master node cannot be scaled after
     *         initial configuration.
     */
    public Integer minimumCapacityUnits() {
        return minimumCapacityUnits;
    }

    /**
     * <p>
     * The upper boundary of EC2 units. It is measured through VCPU cores or instances for instance groups and measured
     * through units for instance fleets. Managed scaling activities are not allowed beyond this boundary. The limit
     * only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
     * </p>
     * 
     * @return The upper boundary of EC2 units. It is measured through VCPU cores or instances for instance groups and
     *         measured through units for instance fleets. Managed scaling activities are not allowed beyond this
     *         boundary. The limit only applies to the core and task nodes. The master node cannot be scaled after
     *         initial configuration.
     */
    public Integer maximumCapacityUnits() {
        return maximumCapacityUnits;
    }

    /**
     * <p>
     * The upper boundary of on-demand EC2 units. It is measured through VCPU cores or instances for instance groups and
     * measured through units for instance fleets. The on-demand units are not allowed to scale beyond this boundary.
     * The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
     * </p>
     * 
     * @return The upper boundary of on-demand EC2 units. It is measured through VCPU cores or instances for instance
     *         groups and measured through units for instance fleets. The on-demand units are not allowed to scale
     *         beyond this boundary. The limit only applies to the core and task nodes. The master node cannot be scaled
     *         after initial configuration.
     */
    public Integer maximumOnDemandCapacityUnits() {
        return maximumOnDemandCapacityUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(unitTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(minimumCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(maximumCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(maximumOnDemandCapacityUnits());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeLimits)) {
            return false;
        }
        ComputeLimits other = (ComputeLimits) obj;
        return Objects.equals(unitTypeAsString(), other.unitTypeAsString())
                && Objects.equals(minimumCapacityUnits(), other.minimumCapacityUnits())
                && Objects.equals(maximumCapacityUnits(), other.maximumCapacityUnits())
                && Objects.equals(maximumOnDemandCapacityUnits(), other.maximumOnDemandCapacityUnits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ComputeLimits").add("UnitType", unitTypeAsString())
                .add("MinimumCapacityUnits", minimumCapacityUnits()).add("MaximumCapacityUnits", maximumCapacityUnits())
                .add("MaximumOnDemandCapacityUnits", maximumOnDemandCapacityUnits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UnitType":
            return Optional.ofNullable(clazz.cast(unitTypeAsString()));
        case "MinimumCapacityUnits":
            return Optional.ofNullable(clazz.cast(minimumCapacityUnits()));
        case "MaximumCapacityUnits":
            return Optional.ofNullable(clazz.cast(maximumCapacityUnits()));
        case "MaximumOnDemandCapacityUnits":
            return Optional.ofNullable(clazz.cast(maximumOnDemandCapacityUnits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComputeLimits, T> g) {
        return obj -> g.apply((ComputeLimits) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputeLimits> {
        /**
         * <p>
         * The unit type used for specifying a managed scaling policy.
         * </p>
         * 
         * @param unitType
         *        The unit type used for specifying a managed scaling policy.
         * @see ComputeLimitsUnitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeLimitsUnitType
         */
        Builder unitType(String unitType);

        /**
         * <p>
         * The unit type used for specifying a managed scaling policy.
         * </p>
         * 
         * @param unitType
         *        The unit type used for specifying a managed scaling policy.
         * @see ComputeLimitsUnitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeLimitsUnitType
         */
        Builder unitType(ComputeLimitsUnitType unitType);

        /**
         * <p>
         * The lower boundary of EC2 units. It is measured through VCPU cores or instances for instance groups and
         * measured through units for instance fleets. Managed scaling activities are not allowed beyond this boundary.
         * The limit only applies to the core and task nodes. The master node cannot be scaled after initial
         * configuration.
         * </p>
         * 
         * @param minimumCapacityUnits
         *        The lower boundary of EC2 units. It is measured through VCPU cores or instances for instance groups
         *        and measured through units for instance fleets. Managed scaling activities are not allowed beyond this
         *        boundary. The limit only applies to the core and task nodes. The master node cannot be scaled after
         *        initial configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumCapacityUnits(Integer minimumCapacityUnits);

        /**
         * <p>
         * The upper boundary of EC2 units. It is measured through VCPU cores or instances for instance groups and
         * measured through units for instance fleets. Managed scaling activities are not allowed beyond this boundary.
         * The limit only applies to the core and task nodes. The master node cannot be scaled after initial
         * configuration.
         * </p>
         * 
         * @param maximumCapacityUnits
         *        The upper boundary of EC2 units. It is measured through VCPU cores or instances for instance groups
         *        and measured through units for instance fleets. Managed scaling activities are not allowed beyond this
         *        boundary. The limit only applies to the core and task nodes. The master node cannot be scaled after
         *        initial configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumCapacityUnits(Integer maximumCapacityUnits);

        /**
         * <p>
         * The upper boundary of on-demand EC2 units. It is measured through VCPU cores or instances for instance groups
         * and measured through units for instance fleets. The on-demand units are not allowed to scale beyond this
         * boundary. The limit only applies to the core and task nodes. The master node cannot be scaled after initial
         * configuration.
         * </p>
         * 
         * @param maximumOnDemandCapacityUnits
         *        The upper boundary of on-demand EC2 units. It is measured through VCPU cores or instances for instance
         *        groups and measured through units for instance fleets. The on-demand units are not allowed to scale
         *        beyond this boundary. The limit only applies to the core and task nodes. The master node cannot be
         *        scaled after initial configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumOnDemandCapacityUnits(Integer maximumOnDemandCapacityUnits);
    }

    static final class BuilderImpl implements Builder {
        private String unitType;

        private Integer minimumCapacityUnits;

        private Integer maximumCapacityUnits;

        private Integer maximumOnDemandCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeLimits model) {
            unitType(model.unitType);
            minimumCapacityUnits(model.minimumCapacityUnits);
            maximumCapacityUnits(model.maximumCapacityUnits);
            maximumOnDemandCapacityUnits(model.maximumOnDemandCapacityUnits);
        }

        public final String getUnitType() {
            return unitType;
        }

        @Override
        public final Builder unitType(String unitType) {
            this.unitType = unitType;
            return this;
        }

        @Override
        public final Builder unitType(ComputeLimitsUnitType unitType) {
            this.unitType(unitType == null ? null : unitType.toString());
            return this;
        }

        public final void setUnitType(String unitType) {
            this.unitType = unitType;
        }

        public final Integer getMinimumCapacityUnits() {
            return minimumCapacityUnits;
        }

        @Override
        public final Builder minimumCapacityUnits(Integer minimumCapacityUnits) {
            this.minimumCapacityUnits = minimumCapacityUnits;
            return this;
        }

        public final void setMinimumCapacityUnits(Integer minimumCapacityUnits) {
            this.minimumCapacityUnits = minimumCapacityUnits;
        }

        public final Integer getMaximumCapacityUnits() {
            return maximumCapacityUnits;
        }

        @Override
        public final Builder maximumCapacityUnits(Integer maximumCapacityUnits) {
            this.maximumCapacityUnits = maximumCapacityUnits;
            return this;
        }

        public final void setMaximumCapacityUnits(Integer maximumCapacityUnits) {
            this.maximumCapacityUnits = maximumCapacityUnits;
        }

        public final Integer getMaximumOnDemandCapacityUnits() {
            return maximumOnDemandCapacityUnits;
        }

        @Override
        public final Builder maximumOnDemandCapacityUnits(Integer maximumOnDemandCapacityUnits) {
            this.maximumOnDemandCapacityUnits = maximumOnDemandCapacityUnits;
            return this;
        }

        public final void setMaximumOnDemandCapacityUnits(Integer maximumOnDemandCapacityUnits) {
            this.maximumOnDemandCapacityUnits = maximumOnDemandCapacityUnits;
        }

        @Override
        public ComputeLimits build() {
            return new ComputeLimits(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
