/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the <a>AddJobFlowSteps</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddJobFlowStepsResponse extends EmrResponse implements
        ToCopyableBuilder<AddJobFlowStepsResponse.Builder, AddJobFlowStepsResponse> {
    private static final SdkField<List<String>> STEP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AddJobFlowStepsResponse::stepIds))
            .setter(setter(Builder::stepIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_IDS_FIELD));

    private final List<String> stepIds;

    private AddJobFlowStepsResponse(BuilderImpl builder) {
        super(builder);
        this.stepIds = builder.stepIds;
    }

    /**
     * Returns true if the StepIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasStepIds() {
        return stepIds != null && !(stepIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of the list of steps added to the job flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStepIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The identifiers of the list of steps added to the job flow.
     */
    public List<String> stepIds() {
        return stepIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stepIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddJobFlowStepsResponse)) {
            return false;
        }
        AddJobFlowStepsResponse other = (AddJobFlowStepsResponse) obj;
        return Objects.equals(stepIds(), other.stepIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AddJobFlowStepsResponse").add("StepIds", stepIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StepIds":
            return Optional.ofNullable(clazz.cast(stepIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddJobFlowStepsResponse, T> g) {
        return obj -> g.apply((AddJobFlowStepsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrResponse.Builder, SdkPojo, CopyableBuilder<Builder, AddJobFlowStepsResponse> {
        /**
         * <p>
         * The identifiers of the list of steps added to the job flow.
         * </p>
         * 
         * @param stepIds
         *        The identifiers of the list of steps added to the job flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepIds(Collection<String> stepIds);

        /**
         * <p>
         * The identifiers of the list of steps added to the job flow.
         * </p>
         * 
         * @param stepIds
         *        The identifiers of the list of steps added to the job flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepIds(String... stepIds);
    }

    static final class BuilderImpl extends EmrResponse.BuilderImpl implements Builder {
        private List<String> stepIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddJobFlowStepsResponse model) {
            super(model);
            stepIds(model.stepIds);
        }

        public final Collection<String> getStepIds() {
            return stepIds;
        }

        @Override
        public final Builder stepIds(Collection<String> stepIds) {
            this.stepIds = StepIdsListCopier.copy(stepIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepIds(String... stepIds) {
            stepIds(Arrays.asList(stepIds));
            return this;
        }

        public final void setStepIds(Collection<String> stepIds) {
            this.stepIds = StepIdsListCopier.copy(stepIds);
        }

        @Override
        public AddJobFlowStepsResponse build() {
            return new AddJobFlowStepsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
