/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to an AddInstanceGroups call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddInstanceGroupsRequest extends EmrRequest implements
        ToCopyableBuilder<AddInstanceGroupsRequest.Builder, AddInstanceGroupsRequest> {
    private static final SdkField<List<InstanceGroupConfig>> INSTANCE_GROUPS_FIELD = SdkField
            .<List<InstanceGroupConfig>> builder(MarshallingType.LIST)
            .getter(getter(AddInstanceGroupsRequest::instanceGroups))
            .setter(setter(Builder::instanceGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceGroupConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceGroupConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> JOB_FLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AddInstanceGroupsRequest::jobFlowId)).setter(setter(Builder::jobFlowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobFlowId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_GROUPS_FIELD,
            JOB_FLOW_ID_FIELD));

    private final List<InstanceGroupConfig> instanceGroups;

    private final String jobFlowId;

    private AddInstanceGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceGroups = builder.instanceGroups;
        this.jobFlowId = builder.jobFlowId;
    }

    /**
     * Returns true if the InstanceGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInstanceGroups() {
        return instanceGroups != null && !(instanceGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Instance groups to add.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Instance groups to add.
     */
    public List<InstanceGroupConfig> instanceGroups() {
        return instanceGroups;
    }

    /**
     * <p>
     * Job flow in which to add the instance groups.
     * </p>
     * 
     * @return Job flow in which to add the instance groups.
     */
    public String jobFlowId() {
        return jobFlowId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceGroups());
        hashCode = 31 * hashCode + Objects.hashCode(jobFlowId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddInstanceGroupsRequest)) {
            return false;
        }
        AddInstanceGroupsRequest other = (AddInstanceGroupsRequest) obj;
        return Objects.equals(instanceGroups(), other.instanceGroups()) && Objects.equals(jobFlowId(), other.jobFlowId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AddInstanceGroupsRequest").add("InstanceGroups", instanceGroups()).add("JobFlowId", jobFlowId())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceGroups":
            return Optional.ofNullable(clazz.cast(instanceGroups()));
        case "JobFlowId":
            return Optional.ofNullable(clazz.cast(jobFlowId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddInstanceGroupsRequest, T> g) {
        return obj -> g.apply((AddInstanceGroupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrRequest.Builder, SdkPojo, CopyableBuilder<Builder, AddInstanceGroupsRequest> {
        /**
         * <p>
         * Instance groups to add.
         * </p>
         * 
         * @param instanceGroups
         *        Instance groups to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroups(Collection<InstanceGroupConfig> instanceGroups);

        /**
         * <p>
         * Instance groups to add.
         * </p>
         * 
         * @param instanceGroups
         *        Instance groups to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroups(InstanceGroupConfig... instanceGroups);

        /**
         * <p>
         * Instance groups to add.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceGroupConfig>.Builder} avoiding the
         * need to create one manually via {@link List<InstanceGroupConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceGroupConfig>.Builder#build()} is called immediately
         * and its result is passed to {@link #instanceGroups(List<InstanceGroupConfig>)}.
         * 
         * @param instanceGroups
         *        a consumer that will call methods on {@link List<InstanceGroupConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceGroups(List<InstanceGroupConfig>)
         */
        Builder instanceGroups(Consumer<InstanceGroupConfig.Builder>... instanceGroups);

        /**
         * <p>
         * Job flow in which to add the instance groups.
         * </p>
         * 
         * @param jobFlowId
         *        Job flow in which to add the instance groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobFlowId(String jobFlowId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrRequest.BuilderImpl implements Builder {
        private List<InstanceGroupConfig> instanceGroups = DefaultSdkAutoConstructList.getInstance();

        private String jobFlowId;

        private BuilderImpl() {
        }

        private BuilderImpl(AddInstanceGroupsRequest model) {
            super(model);
            instanceGroups(model.instanceGroups);
            jobFlowId(model.jobFlowId);
        }

        public final Collection<InstanceGroupConfig.Builder> getInstanceGroups() {
            return instanceGroups != null ? instanceGroups.stream().map(InstanceGroupConfig::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceGroups(Collection<InstanceGroupConfig> instanceGroups) {
            this.instanceGroups = InstanceGroupConfigListCopier.copy(instanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(InstanceGroupConfig... instanceGroups) {
            instanceGroups(Arrays.asList(instanceGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(Consumer<InstanceGroupConfig.Builder>... instanceGroups) {
            instanceGroups(Stream.of(instanceGroups).map(c -> InstanceGroupConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceGroups(Collection<InstanceGroupConfig.BuilderImpl> instanceGroups) {
            this.instanceGroups = InstanceGroupConfigListCopier.copyFromBuilder(instanceGroups);
        }

        public final String getJobFlowId() {
            return jobFlowId;
        }

        @Override
        public final Builder jobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
            return this;
        }

        public final void setJobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddInstanceGroupsRequest build() {
            return new AddInstanceGroupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
