/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddInstanceFleetResponse extends EmrResponse implements
        ToCopyableBuilder<AddInstanceFleetResponse.Builder, AddInstanceFleetResponse> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AddInstanceFleetResponse::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()).build();

    private static final SdkField<String> INSTANCE_FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AddInstanceFleetResponse::instanceFleetId)).setter(setter(Builder::instanceFleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFleetId").build()).build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AddInstanceFleetResponse::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD,
            INSTANCE_FLEET_ID_FIELD, CLUSTER_ARN_FIELD));

    private final String clusterId;

    private final String instanceFleetId;

    private final String clusterArn;

    private AddInstanceFleetResponse(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.instanceFleetId = builder.instanceFleetId;
        this.clusterArn = builder.clusterArn;
    }

    /**
     * <p>
     * The unique identifier of the cluster.
     * </p>
     * 
     * @return The unique identifier of the cluster.
     */
    public String clusterId() {
        return clusterId;
    }

    /**
     * <p>
     * The unique identifier of the instance fleet.
     * </p>
     * 
     * @return The unique identifier of the instance fleet.
     */
    public String instanceFleetId() {
        return instanceFleetId;
    }

    /**
     * <p>
     * The Amazon Resource Name of the cluster.
     * </p>
     * 
     * @return The Amazon Resource Name of the cluster.
     */
    public String clusterArn() {
        return clusterArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceFleetId());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddInstanceFleetResponse)) {
            return false;
        }
        AddInstanceFleetResponse other = (AddInstanceFleetResponse) obj;
        return Objects.equals(clusterId(), other.clusterId()) && Objects.equals(instanceFleetId(), other.instanceFleetId())
                && Objects.equals(clusterArn(), other.clusterArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AddInstanceFleetResponse").add("ClusterId", clusterId())
                .add("InstanceFleetId", instanceFleetId()).add("ClusterArn", clusterArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "InstanceFleetId":
            return Optional.ofNullable(clazz.cast(instanceFleetId()));
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddInstanceFleetResponse, T> g) {
        return obj -> g.apply((AddInstanceFleetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrResponse.Builder, SdkPojo, CopyableBuilder<Builder, AddInstanceFleetResponse> {
        /**
         * <p>
         * The unique identifier of the cluster.
         * </p>
         * 
         * @param clusterId
         *        The unique identifier of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * The unique identifier of the instance fleet.
         * </p>
         * 
         * @param instanceFleetId
         *        The unique identifier of the instance fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceFleetId(String instanceFleetId);

        /**
         * <p>
         * The Amazon Resource Name of the cluster.
         * </p>
         * 
         * @param clusterArn
         *        The Amazon Resource Name of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);
    }

    static final class BuilderImpl extends EmrResponse.BuilderImpl implements Builder {
        private String clusterId;

        private String instanceFleetId;

        private String clusterArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AddInstanceFleetResponse model) {
            super(model);
            clusterId(model.clusterId);
            instanceFleetId(model.instanceFleetId);
            clusterArn(model.clusterArn);
        }

        public final String getClusterId() {
            return clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getInstanceFleetId() {
            return instanceFleetId;
        }

        @Override
        public final Builder instanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
            return this;
        }

        public final void setInstanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public AddInstanceFleetResponse build() {
            return new AddInstanceFleetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
