/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.ScalingConstraints;
import software.amazon.awssdk.services.emr.model.ScalingRule;
import software.amazon.awssdk.services.emr.model.ScalingRuleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoScalingPolicy> {
    private static final SdkField<ScalingConstraints> CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AutoScalingPolicy.getter(AutoScalingPolicy::constraints)).setter(AutoScalingPolicy.setter(Builder::constraints)).constructor(ScalingConstraints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Constraints").build()}).build();
    private static final SdkField<List<ScalingRule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AutoScalingPolicy.getter(AutoScalingPolicy::rules)).setter(AutoScalingPolicy.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScalingRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSTRAINTS_FIELD, RULES_FIELD));
    private static final long serialVersionUID = 1L;
    private final ScalingConstraints constraints;
    private final List<ScalingRule> rules;

    private AutoScalingPolicy(BuilderImpl builder) {
        this.constraints = builder.constraints;
        this.rules = builder.rules;
    }

    public ScalingConstraints constraints() {
        return this.constraints;
    }

    public boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public List<ScalingRule> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.constraints());
        hashCode = 31 * hashCode + Objects.hashCode(this.rules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingPolicy)) {
            return false;
        }
        AutoScalingPolicy other = (AutoScalingPolicy)obj;
        return Objects.equals(this.constraints(), other.constraints()) && Objects.equals(this.rules(), other.rules());
    }

    public String toString() {
        return ToString.builder((String)"AutoScalingPolicy").add("Constraints", (Object)this.constraints()).add("Rules", this.rules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Constraints": {
                return Optional.ofNullable(clazz.cast(this.constraints()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingPolicy, T> g) {
        return obj -> g.apply((AutoScalingPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ScalingConstraints constraints;
        private List<ScalingRule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingPolicy model) {
            this.constraints(model.constraints);
            this.rules(model.rules);
        }

        public final ScalingConstraints.Builder getConstraints() {
            return this.constraints != null ? this.constraints.toBuilder() : null;
        }

        @Override
        public final Builder constraints(ScalingConstraints constraints) {
            this.constraints = constraints;
            return this;
        }

        public final void setConstraints(ScalingConstraints.BuilderImpl constraints) {
            this.constraints = constraints != null ? constraints.build() : null;
        }

        public final Collection<ScalingRule.Builder> getRules() {
            return this.rules != null ? (Collection)this.rules.stream().map(ScalingRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<ScalingRule> rules) {
            this.rules = ScalingRuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(ScalingRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<ScalingRule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (ScalingRule)((ScalingRule.Builder)ScalingRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<ScalingRule.BuilderImpl> rules) {
            this.rules = ScalingRuleListCopier.copyFromBuilder(rules);
        }

        public AutoScalingPolicy build() {
            return new AutoScalingPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoScalingPolicy> {
        public Builder constraints(ScalingConstraints var1);

        default public Builder constraints(Consumer<ScalingConstraints.Builder> constraints) {
            return this.constraints((ScalingConstraints)((ScalingConstraints.Builder)ScalingConstraints.builder().applyMutation(constraints)).build());
        }

        public Builder rules(Collection<ScalingRule> var1);

        public Builder rules(ScalingRule ... var1);

        public Builder rules(Consumer<ScalingRule.Builder> ... var1);
    }
}

