/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.AutoScalingPolicy;
import software.amazon.awssdk.services.emr.model.Configuration;
import software.amazon.awssdk.services.emr.model.ConfigurationListCopier;
import software.amazon.awssdk.services.emr.model.EbsConfiguration;
import software.amazon.awssdk.services.emr.model.InstanceRoleType;
import software.amazon.awssdk.services.emr.model.MarketType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceGroupConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceGroupConfig> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceGroupConfig.getter(InstanceGroupConfig::name)).setter(InstanceGroupConfig.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> MARKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceGroupConfig.getter(InstanceGroupConfig::marketAsString)).setter(InstanceGroupConfig.setter(Builder::market)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Market").build()}).build();
    private static final SdkField<String> INSTANCE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceGroupConfig.getter(InstanceGroupConfig::instanceRoleAsString)).setter(InstanceGroupConfig.setter(Builder::instanceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRole").build()}).build();
    private static final SdkField<String> BID_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceGroupConfig.getter(InstanceGroupConfig::bidPrice)).setter(InstanceGroupConfig.setter(Builder::bidPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BidPrice").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceGroupConfig.getter(InstanceGroupConfig::instanceType)).setter(InstanceGroupConfig.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(InstanceGroupConfig.getter(InstanceGroupConfig::instanceCount)).setter(InstanceGroupConfig.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()}).build();
    private static final SdkField<List<Configuration>> CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(InstanceGroupConfig.getter(InstanceGroupConfig::configurations)).setter(InstanceGroupConfig.setter(Builder::configurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EbsConfiguration> EBS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(InstanceGroupConfig.getter(InstanceGroupConfig::ebsConfiguration)).setter(InstanceGroupConfig.setter(Builder::ebsConfiguration)).constructor(EbsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsConfiguration").build()}).build();
    private static final SdkField<AutoScalingPolicy> AUTO_SCALING_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(InstanceGroupConfig.getter(InstanceGroupConfig::autoScalingPolicy)).setter(InstanceGroupConfig.setter(Builder::autoScalingPolicy)).constructor(AutoScalingPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MARKET_FIELD, INSTANCE_ROLE_FIELD, BID_PRICE_FIELD, INSTANCE_TYPE_FIELD, INSTANCE_COUNT_FIELD, CONFIGURATIONS_FIELD, EBS_CONFIGURATION_FIELD, AUTO_SCALING_POLICY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String market;
    private final String instanceRole;
    private final String bidPrice;
    private final String instanceType;
    private final Integer instanceCount;
    private final List<Configuration> configurations;
    private final EbsConfiguration ebsConfiguration;
    private final AutoScalingPolicy autoScalingPolicy;

    private InstanceGroupConfig(BuilderImpl builder) {
        this.name = builder.name;
        this.market = builder.market;
        this.instanceRole = builder.instanceRole;
        this.bidPrice = builder.bidPrice;
        this.instanceType = builder.instanceType;
        this.instanceCount = builder.instanceCount;
        this.configurations = builder.configurations;
        this.ebsConfiguration = builder.ebsConfiguration;
        this.autoScalingPolicy = builder.autoScalingPolicy;
    }

    public String name() {
        return this.name;
    }

    public MarketType market() {
        return MarketType.fromValue(this.market);
    }

    public String marketAsString() {
        return this.market;
    }

    public InstanceRoleType instanceRole() {
        return InstanceRoleType.fromValue(this.instanceRole);
    }

    public String instanceRoleAsString() {
        return this.instanceRole;
    }

    public String bidPrice() {
        return this.bidPrice;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public boolean hasConfigurations() {
        return this.configurations != null && !(this.configurations instanceof SdkAutoConstructList);
    }

    public List<Configuration> configurations() {
        return this.configurations;
    }

    public EbsConfiguration ebsConfiguration() {
        return this.ebsConfiguration;
    }

    public AutoScalingPolicy autoScalingPolicy() {
        return this.autoScalingPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.marketAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bidPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingPolicy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceGroupConfig)) {
            return false;
        }
        InstanceGroupConfig other = (InstanceGroupConfig)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.marketAsString(), other.marketAsString()) && Objects.equals(this.instanceRoleAsString(), other.instanceRoleAsString()) && Objects.equals(this.bidPrice(), other.bidPrice()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.configurations(), other.configurations()) && Objects.equals(this.ebsConfiguration(), other.ebsConfiguration()) && Objects.equals(this.autoScalingPolicy(), other.autoScalingPolicy());
    }

    public String toString() {
        return ToString.builder((String)"InstanceGroupConfig").add("Name", (Object)this.name()).add("Market", (Object)this.marketAsString()).add("InstanceRole", (Object)this.instanceRoleAsString()).add("BidPrice", (Object)this.bidPrice()).add("InstanceType", (Object)this.instanceType()).add("InstanceCount", (Object)this.instanceCount()).add("Configurations", this.configurations()).add("EbsConfiguration", (Object)this.ebsConfiguration()).add("AutoScalingPolicy", (Object)this.autoScalingPolicy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Market": {
                return Optional.ofNullable(clazz.cast(this.marketAsString()));
            }
            case "InstanceRole": {
                return Optional.ofNullable(clazz.cast(this.instanceRoleAsString()));
            }
            case "BidPrice": {
                return Optional.ofNullable(clazz.cast(this.bidPrice()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "Configurations": {
                return Optional.ofNullable(clazz.cast(this.configurations()));
            }
            case "EbsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.ebsConfiguration()));
            }
            case "AutoScalingPolicy": {
                return Optional.ofNullable(clazz.cast(this.autoScalingPolicy()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceGroupConfig, T> g) {
        return obj -> g.apply((InstanceGroupConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String market;
        private String instanceRole;
        private String bidPrice;
        private String instanceType;
        private Integer instanceCount;
        private List<Configuration> configurations = DefaultSdkAutoConstructList.getInstance();
        private EbsConfiguration ebsConfiguration;
        private AutoScalingPolicy autoScalingPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceGroupConfig model) {
            this.name(model.name);
            this.market(model.market);
            this.instanceRole(model.instanceRole);
            this.bidPrice(model.bidPrice);
            this.instanceType(model.instanceType);
            this.instanceCount(model.instanceCount);
            this.configurations(model.configurations);
            this.ebsConfiguration(model.ebsConfiguration);
            this.autoScalingPolicy(model.autoScalingPolicy);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMarketAsString() {
            return this.market;
        }

        @Override
        public final Builder market(String market) {
            this.market = market;
            return this;
        }

        @Override
        public final Builder market(MarketType market) {
            this.market(market == null ? null : market.toString());
            return this;
        }

        public final void setMarket(String market) {
            this.market = market;
        }

        public final String getInstanceRoleAsString() {
            return this.instanceRole;
        }

        @Override
        public final Builder instanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
            return this;
        }

        @Override
        public final Builder instanceRole(InstanceRoleType instanceRole) {
            this.instanceRole(instanceRole == null ? null : instanceRole.toString());
            return this;
        }

        public final void setInstanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
        }

        public final String getBidPrice() {
            return this.bidPrice;
        }

        @Override
        public final Builder bidPrice(String bidPrice) {
            this.bidPrice = bidPrice;
            return this;
        }

        public final void setBidPrice(String bidPrice) {
            this.bidPrice = bidPrice;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final Collection<Configuration.Builder> getConfigurations() {
            return this.configurations != null ? (Collection)this.configurations.stream().map(Configuration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurations(Collection<Configuration> configurations) {
            this.configurations = ConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Configuration ... configurations) {
            this.configurations(Arrays.asList(configurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Consumer<Configuration.Builder> ... configurations) {
            this.configurations(Stream.of(configurations).map(c -> (Configuration)((Configuration.Builder)Configuration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConfigurations(Collection<Configuration.BuilderImpl> configurations) {
            this.configurations = ConfigurationListCopier.copyFromBuilder(configurations);
        }

        public final EbsConfiguration.Builder getEbsConfiguration() {
            return this.ebsConfiguration != null ? this.ebsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder ebsConfiguration(EbsConfiguration ebsConfiguration) {
            this.ebsConfiguration = ebsConfiguration;
            return this;
        }

        public final void setEbsConfiguration(EbsConfiguration.BuilderImpl ebsConfiguration) {
            this.ebsConfiguration = ebsConfiguration != null ? ebsConfiguration.build() : null;
        }

        public final AutoScalingPolicy.Builder getAutoScalingPolicy() {
            return this.autoScalingPolicy != null ? this.autoScalingPolicy.toBuilder() : null;
        }

        @Override
        public final Builder autoScalingPolicy(AutoScalingPolicy autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy;
            return this;
        }

        public final void setAutoScalingPolicy(AutoScalingPolicy.BuilderImpl autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy != null ? autoScalingPolicy.build() : null;
        }

        public InstanceGroupConfig build() {
            return new InstanceGroupConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceGroupConfig> {
        public Builder name(String var1);

        public Builder market(String var1);

        public Builder market(MarketType var1);

        public Builder instanceRole(String var1);

        public Builder instanceRole(InstanceRoleType var1);

        public Builder bidPrice(String var1);

        public Builder instanceType(String var1);

        public Builder instanceCount(Integer var1);

        public Builder configurations(Collection<Configuration> var1);

        public Builder configurations(Configuration ... var1);

        public Builder configurations(Consumer<Configuration.Builder> ... var1);

        public Builder ebsConfiguration(EbsConfiguration var1);

        default public Builder ebsConfiguration(Consumer<EbsConfiguration.Builder> ebsConfiguration) {
            return this.ebsConfiguration((EbsConfiguration)((EbsConfiguration.Builder)EbsConfiguration.builder().applyMutation(ebsConfiguration)).build());
        }

        public Builder autoScalingPolicy(AutoScalingPolicy var1);

        default public Builder autoScalingPolicy(Consumer<AutoScalingPolicy.Builder> autoScalingPolicy) {
            return this.autoScalingPolicy((AutoScalingPolicy)((AutoScalingPolicy.Builder)AutoScalingPolicy.builder().applyMutation(autoScalingPolicy)).build());
        }
    }
}

