/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration of the script to run during a bootstrap action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScriptBootstrapActionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ScriptBootstrapActionConfig.Builder, ScriptBootstrapActionConfig> {
    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ScriptBootstrapActionConfig::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<List<String>> ARGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ScriptBootstrapActionConfig::args))
            .setter(setter(Builder::args))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Args").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, ARGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String path;

    private final List<String> args;

    private ScriptBootstrapActionConfig(BuilderImpl builder) {
        this.path = builder.path;
        this.args = builder.args;
    }

    /**
     * <p>
     * Location of the script to run during a bootstrap action. Can be either a location in Amazon S3 or on a local file
     * system.
     * </p>
     * 
     * @return Location of the script to run during a bootstrap action. Can be either a location in Amazon S3 or on a
     *         local file system.
     */
    public String path() {
        return path;
    }

    /**
     * Returns true if the Args property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasArgs() {
        return args != null && !(args instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of command line arguments to pass to the bootstrap action script.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasArgs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of command line arguments to pass to the bootstrap action script.
     */
    public List<String> args() {
        return args;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(args());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScriptBootstrapActionConfig)) {
            return false;
        }
        ScriptBootstrapActionConfig other = (ScriptBootstrapActionConfig) obj;
        return Objects.equals(path(), other.path()) && Objects.equals(args(), other.args());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ScriptBootstrapActionConfig").add("Path", path()).add("Args", args()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "Args":
            return Optional.ofNullable(clazz.cast(args()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScriptBootstrapActionConfig, T> g) {
        return obj -> g.apply((ScriptBootstrapActionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScriptBootstrapActionConfig> {
        /**
         * <p>
         * Location of the script to run during a bootstrap action. Can be either a location in Amazon S3 or on a local
         * file system.
         * </p>
         * 
         * @param path
         *        Location of the script to run during a bootstrap action. Can be either a location in Amazon S3 or on a
         *        local file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * A list of command line arguments to pass to the bootstrap action script.
         * </p>
         * 
         * @param args
         *        A list of command line arguments to pass to the bootstrap action script.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder args(Collection<String> args);

        /**
         * <p>
         * A list of command line arguments to pass to the bootstrap action script.
         * </p>
         * 
         * @param args
         *        A list of command line arguments to pass to the bootstrap action script.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder args(String... args);
    }

    static final class BuilderImpl implements Builder {
        private String path;

        private List<String> args = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ScriptBootstrapActionConfig model) {
            path(model.path);
            args(model.args);
        }

        public final String getPath() {
            return path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final Collection<String> getArgs() {
            return args;
        }

        @Override
        public final Builder args(Collection<String> args) {
            this.args = XmlStringListCopier.copy(args);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder args(String... args) {
            args(Arrays.asList(args));
            return this;
        }

        public final void setArgs(Collection<String> args) {
            this.args = XmlStringListCopier.copy(args);
        }

        @Override
        public ScriptBootstrapActionConfig build() {
            return new ScriptBootstrapActionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
