/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAutoScalingPolicyResponse extends EmrResponse implements
        ToCopyableBuilder<PutAutoScalingPolicyResponse.Builder, PutAutoScalingPolicyResponse> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutAutoScalingPolicyResponse::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()).build();

    private static final SdkField<String> INSTANCE_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutAutoScalingPolicyResponse::instanceGroupId)).setter(setter(Builder::instanceGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupId").build()).build();

    private static final SdkField<AutoScalingPolicyDescription> AUTO_SCALING_POLICY_FIELD = SdkField
            .<AutoScalingPolicyDescription> builder(MarshallingType.SDK_POJO)
            .getter(getter(PutAutoScalingPolicyResponse::autoScalingPolicy)).setter(setter(Builder::autoScalingPolicy))
            .constructor(AutoScalingPolicyDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingPolicy").build()).build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutAutoScalingPolicyResponse::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD,
            INSTANCE_GROUP_ID_FIELD, AUTO_SCALING_POLICY_FIELD, CLUSTER_ARN_FIELD));

    private final String clusterId;

    private final String instanceGroupId;

    private final AutoScalingPolicyDescription autoScalingPolicy;

    private final String clusterArn;

    private PutAutoScalingPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.instanceGroupId = builder.instanceGroupId;
        this.autoScalingPolicy = builder.autoScalingPolicy;
        this.clusterArn = builder.clusterArn;
    }

    /**
     * <p>
     * Specifies the ID of a cluster. The instance group to which the automatic scaling policy is applied is within this
     * cluster.
     * </p>
     * 
     * @return Specifies the ID of a cluster. The instance group to which the automatic scaling policy is applied is
     *         within this cluster.
     */
    public String clusterId() {
        return clusterId;
    }

    /**
     * <p>
     * Specifies the ID of the instance group to which the scaling policy is applied.
     * </p>
     * 
     * @return Specifies the ID of the instance group to which the scaling policy is applied.
     */
    public String instanceGroupId() {
        return instanceGroupId;
    }

    /**
     * <p>
     * The automatic scaling policy definition.
     * </p>
     * 
     * @return The automatic scaling policy definition.
     */
    public AutoScalingPolicyDescription autoScalingPolicy() {
        return autoScalingPolicy;
    }

    /**
     * <p>
     * The Amazon Resource Name of the cluster.
     * </p>
     * 
     * @return The Amazon Resource Name of the cluster.
     */
    public String clusterArn() {
        return clusterArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAutoScalingPolicyResponse)) {
            return false;
        }
        PutAutoScalingPolicyResponse other = (PutAutoScalingPolicyResponse) obj;
        return Objects.equals(clusterId(), other.clusterId()) && Objects.equals(instanceGroupId(), other.instanceGroupId())
                && Objects.equals(autoScalingPolicy(), other.autoScalingPolicy())
                && Objects.equals(clusterArn(), other.clusterArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutAutoScalingPolicyResponse").add("ClusterId", clusterId())
                .add("InstanceGroupId", instanceGroupId()).add("AutoScalingPolicy", autoScalingPolicy())
                .add("ClusterArn", clusterArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "InstanceGroupId":
            return Optional.ofNullable(clazz.cast(instanceGroupId()));
        case "AutoScalingPolicy":
            return Optional.ofNullable(clazz.cast(autoScalingPolicy()));
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAutoScalingPolicyResponse, T> g) {
        return obj -> g.apply((PutAutoScalingPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutAutoScalingPolicyResponse> {
        /**
         * <p>
         * Specifies the ID of a cluster. The instance group to which the automatic scaling policy is applied is within
         * this cluster.
         * </p>
         * 
         * @param clusterId
         *        Specifies the ID of a cluster. The instance group to which the automatic scaling policy is applied is
         *        within this cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * Specifies the ID of the instance group to which the scaling policy is applied.
         * </p>
         * 
         * @param instanceGroupId
         *        Specifies the ID of the instance group to which the scaling policy is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroupId(String instanceGroupId);

        /**
         * <p>
         * The automatic scaling policy definition.
         * </p>
         * 
         * @param autoScalingPolicy
         *        The automatic scaling policy definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingPolicy(AutoScalingPolicyDescription autoScalingPolicy);

        /**
         * <p>
         * The automatic scaling policy definition.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoScalingPolicyDescription.Builder} avoiding
         * the need to create one manually via {@link AutoScalingPolicyDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoScalingPolicyDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #autoScalingPolicy(AutoScalingPolicyDescription)}.
         * 
         * @param autoScalingPolicy
         *        a consumer that will call methods on {@link AutoScalingPolicyDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoScalingPolicy(AutoScalingPolicyDescription)
         */
        default Builder autoScalingPolicy(Consumer<AutoScalingPolicyDescription.Builder> autoScalingPolicy) {
            return autoScalingPolicy(AutoScalingPolicyDescription.builder().applyMutation(autoScalingPolicy).build());
        }

        /**
         * <p>
         * The Amazon Resource Name of the cluster.
         * </p>
         * 
         * @param clusterArn
         *        The Amazon Resource Name of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);
    }

    static final class BuilderImpl extends EmrResponse.BuilderImpl implements Builder {
        private String clusterId;

        private String instanceGroupId;

        private AutoScalingPolicyDescription autoScalingPolicy;

        private String clusterArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAutoScalingPolicyResponse model) {
            super(model);
            clusterId(model.clusterId);
            instanceGroupId(model.instanceGroupId);
            autoScalingPolicy(model.autoScalingPolicy);
            clusterArn(model.clusterArn);
        }

        public final String getClusterId() {
            return clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getInstanceGroupId() {
            return instanceGroupId;
        }

        @Override
        public final Builder instanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
            return this;
        }

        public final void setInstanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
        }

        public final AutoScalingPolicyDescription.Builder getAutoScalingPolicy() {
            return autoScalingPolicy != null ? autoScalingPolicy.toBuilder() : null;
        }

        @Override
        public final Builder autoScalingPolicy(AutoScalingPolicyDescription autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy;
            return this;
        }

        public final void setAutoScalingPolicy(AutoScalingPolicyDescription.BuilderImpl autoScalingPolicy) {
            this.autoScalingPolicy = autoScalingPolicy != null ? autoScalingPolicy.build() : null;
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public PutAutoScalingPolicyResponse build() {
            return new PutAutoScalingPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
