/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Change the size of some instance groups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyInstanceGroupsRequest extends EmrRequest implements
        ToCopyableBuilder<ModifyInstanceGroupsRequest.Builder, ModifyInstanceGroupsRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyInstanceGroupsRequest::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()).build();

    private static final SdkField<List<InstanceGroupModifyConfig>> INSTANCE_GROUPS_FIELD = SdkField
            .<List<InstanceGroupModifyConfig>> builder(MarshallingType.LIST)
            .getter(getter(ModifyInstanceGroupsRequest::instanceGroups))
            .setter(setter(Builder::instanceGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceGroupModifyConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceGroupModifyConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD,
            INSTANCE_GROUPS_FIELD));

    private final String clusterId;

    private final List<InstanceGroupModifyConfig> instanceGroups;

    private ModifyInstanceGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.instanceGroups = builder.instanceGroups;
    }

    /**
     * <p>
     * The ID of the cluster to which the instance group belongs.
     * </p>
     * 
     * @return The ID of the cluster to which the instance group belongs.
     */
    public String clusterId() {
        return clusterId;
    }

    /**
     * Returns true if the InstanceGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInstanceGroups() {
        return instanceGroups != null && !(instanceGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Instance groups to change.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Instance groups to change.
     */
    public List<InstanceGroupModifyConfig> instanceGroups() {
        return instanceGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceGroups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceGroupsRequest)) {
            return false;
        }
        ModifyInstanceGroupsRequest other = (ModifyInstanceGroupsRequest) obj;
        return Objects.equals(clusterId(), other.clusterId()) && Objects.equals(instanceGroups(), other.instanceGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyInstanceGroupsRequest").add("ClusterId", clusterId())
                .add("InstanceGroups", instanceGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "InstanceGroups":
            return Optional.ofNullable(clazz.cast(instanceGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceGroupsRequest, T> g) {
        return obj -> g.apply((ModifyInstanceGroupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyInstanceGroupsRequest> {
        /**
         * <p>
         * The ID of the cluster to which the instance group belongs.
         * </p>
         * 
         * @param clusterId
         *        The ID of the cluster to which the instance group belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * Instance groups to change.
         * </p>
         * 
         * @param instanceGroups
         *        Instance groups to change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroups(Collection<InstanceGroupModifyConfig> instanceGroups);

        /**
         * <p>
         * Instance groups to change.
         * </p>
         * 
         * @param instanceGroups
         *        Instance groups to change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroups(InstanceGroupModifyConfig... instanceGroups);

        /**
         * <p>
         * Instance groups to change.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceGroupModifyConfig>.Builder}
         * avoiding the need to create one manually via {@link List<InstanceGroupModifyConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceGroupModifyConfig>.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceGroups(List<InstanceGroupModifyConfig>)}.
         * 
         * @param instanceGroups
         *        a consumer that will call methods on {@link List<InstanceGroupModifyConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceGroups(List<InstanceGroupModifyConfig>)
         */
        Builder instanceGroups(Consumer<InstanceGroupModifyConfig.Builder>... instanceGroups);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrRequest.BuilderImpl implements Builder {
        private String clusterId;

        private List<InstanceGroupModifyConfig> instanceGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceGroupsRequest model) {
            super(model);
            clusterId(model.clusterId);
            instanceGroups(model.instanceGroups);
        }

        public final String getClusterId() {
            return clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final Collection<InstanceGroupModifyConfig.Builder> getInstanceGroups() {
            return instanceGroups != null ? instanceGroups.stream().map(InstanceGroupModifyConfig::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceGroups(Collection<InstanceGroupModifyConfig> instanceGroups) {
            this.instanceGroups = InstanceGroupModifyConfigListCopier.copy(instanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(InstanceGroupModifyConfig... instanceGroups) {
            instanceGroups(Arrays.asList(instanceGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(Consumer<InstanceGroupModifyConfig.Builder>... instanceGroups) {
            instanceGroups(Stream.of(instanceGroups).map(c -> InstanceGroupModifyConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceGroups(Collection<InstanceGroupModifyConfig.BuilderImpl> instanceGroups) {
            this.instanceGroups = InstanceGroupModifyConfigListCopier.copyFromBuilder(instanceGroups);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyInstanceGroupsRequest build() {
            return new ModifyInstanceGroupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
