/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This output contains the bootstrap actions detail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBootstrapActionsResponse extends EmrResponse implements
        ToCopyableBuilder<ListBootstrapActionsResponse.Builder, ListBootstrapActionsResponse> {
    private static final SdkField<List<Command>> BOOTSTRAP_ACTIONS_FIELD = SdkField
            .<List<Command>> builder(MarshallingType.LIST)
            .getter(getter(ListBootstrapActionsResponse::bootstrapActions))
            .setter(setter(Builder::bootstrapActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BootstrapActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Command> builder(MarshallingType.SDK_POJO)
                                            .constructor(Command::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListBootstrapActionsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOTSTRAP_ACTIONS_FIELD,
            MARKER_FIELD));

    private final List<Command> bootstrapActions;

    private final String marker;

    private ListBootstrapActionsResponse(BuilderImpl builder) {
        super(builder);
        this.bootstrapActions = builder.bootstrapActions;
        this.marker = builder.marker;
    }

    /**
     * Returns true if the BootstrapActions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasBootstrapActions() {
        return bootstrapActions != null && !(bootstrapActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The bootstrap actions associated with the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBootstrapActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The bootstrap actions associated with the cluster.
     */
    public List<Command> bootstrapActions() {
        return bootstrapActions;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results to retrieve.
     */
    public String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bootstrapActions());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBootstrapActionsResponse)) {
            return false;
        }
        ListBootstrapActionsResponse other = (ListBootstrapActionsResponse) obj;
        return Objects.equals(bootstrapActions(), other.bootstrapActions()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListBootstrapActionsResponse").add("BootstrapActions", bootstrapActions())
                .add("Marker", marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BootstrapActions":
            return Optional.ofNullable(clazz.cast(bootstrapActions()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBootstrapActionsResponse, T> g) {
        return obj -> g.apply((ListBootstrapActionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListBootstrapActionsResponse> {
        /**
         * <p>
         * The bootstrap actions associated with the cluster.
         * </p>
         * 
         * @param bootstrapActions
         *        The bootstrap actions associated with the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bootstrapActions(Collection<Command> bootstrapActions);

        /**
         * <p>
         * The bootstrap actions associated with the cluster.
         * </p>
         * 
         * @param bootstrapActions
         *        The bootstrap actions associated with the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bootstrapActions(Command... bootstrapActions);

        /**
         * <p>
         * The bootstrap actions associated with the cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Command>.Builder} avoiding the need to
         * create one manually via {@link List<Command>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Command>.Builder#build()} is called immediately and its
         * result is passed to {@link #bootstrapActions(List<Command>)}.
         * 
         * @param bootstrapActions
         *        a consumer that will call methods on {@link List<Command>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bootstrapActions(List<Command>)
         */
        Builder bootstrapActions(Consumer<Command.Builder>... bootstrapActions);

        /**
         * <p>
         * The pagination token that indicates the next set of results to retrieve.
         * </p>
         * 
         * @param marker
         *        The pagination token that indicates the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends EmrResponse.BuilderImpl implements Builder {
        private List<Command> bootstrapActions = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBootstrapActionsResponse model) {
            super(model);
            bootstrapActions(model.bootstrapActions);
            marker(model.marker);
        }

        public final Collection<Command.Builder> getBootstrapActions() {
            return bootstrapActions != null ? bootstrapActions.stream().map(Command::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder bootstrapActions(Collection<Command> bootstrapActions) {
            this.bootstrapActions = CommandListCopier.copy(bootstrapActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bootstrapActions(Command... bootstrapActions) {
            bootstrapActions(Arrays.asList(bootstrapActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bootstrapActions(Consumer<Command.Builder>... bootstrapActions) {
            bootstrapActions(Stream.of(bootstrapActions).map(c -> Command.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBootstrapActions(Collection<Command.BuilderImpl> bootstrapActions) {
            this.bootstrapActions = CommandListCopier.copyFromBuilder(bootstrapActions);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListBootstrapActionsResponse build() {
            return new ListBootstrapActionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
