/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This exception occurs when there is something wrong with user input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvalidRequestException extends EmrException implements
        ToCopyableBuilder<InvalidRequestException.Builder, InvalidRequestException> {
    private static final SdkField<String> EMR_ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InvalidRequestException::emrErrorCode)).setter(setter(Builder::emrErrorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMR_ERROR_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String emrErrorCode;

    private InvalidRequestException(BuilderImpl builder) {
        super(builder);
        this.emrErrorCode = builder.emrErrorCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The error code associated with the exception.
     * </p>
     * 
     * @return The error code associated with the exception.
     */
    public String emrErrorCode() {
        return emrErrorCode;
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvalidRequestException, T> g) {
        return obj -> g.apply((InvalidRequestException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvalidRequestException>, EmrException.Builder {
        /**
         * <p>
         * The error code associated with the exception.
         * </p>
         * 
         * @param emrErrorCode
         *        The error code associated with the exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emrErrorCode(String emrErrorCode);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends EmrException.BuilderImpl implements Builder {
        private String emrErrorCode;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidRequestException model) {
            super(model);
            emrErrorCode(model.emrErrorCode);
        }

        public final String getEmrErrorCode() {
            return emrErrorCode;
        }

        @Override
        public final Builder emrErrorCode(String emrErrorCode) {
            this.emrErrorCode = emrErrorCode;
            return this;
        }

        public final void setEmrErrorCode(String emrErrorCode) {
            this.emrErrorCode = emrErrorCode;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public InvalidRequestException build() {
            return new InvalidRequestException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
