/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides historical timestamps for the instance fleet, including the time of creation, the time it became ready to
 * run jobs, and the time of termination.
 * </p>
 * <note>
 * <p>
 * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceFleetTimeline implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceFleetTimeline.Builder, InstanceFleetTimeline> {
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(InstanceFleetTimeline::creationDateTime)).setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDateTime").build()).build();

    private static final SdkField<Instant> READY_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(InstanceFleetTimeline::readyDateTime)).setter(setter(Builder::readyDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadyDateTime").build()).build();

    private static final SdkField<Instant> END_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(InstanceFleetTimeline::endDateTime)).setter(setter(Builder::endDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_DATE_TIME_FIELD,
            READY_DATE_TIME_FIELD, END_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant creationDateTime;

    private final Instant readyDateTime;

    private final Instant endDateTime;

    private InstanceFleetTimeline(BuilderImpl builder) {
        this.creationDateTime = builder.creationDateTime;
        this.readyDateTime = builder.readyDateTime;
        this.endDateTime = builder.endDateTime;
    }

    /**
     * <p>
     * The time and date the instance fleet was created.
     * </p>
     * 
     * @return The time and date the instance fleet was created.
     */
    public Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The time and date the instance fleet was ready to run jobs.
     * </p>
     * 
     * @return The time and date the instance fleet was ready to run jobs.
     */
    public Instant readyDateTime() {
        return readyDateTime;
    }

    /**
     * <p>
     * The time and date the instance fleet terminated.
     * </p>
     * 
     * @return The time and date the instance fleet terminated.
     */
    public Instant endDateTime() {
        return endDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(readyDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(endDateTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceFleetTimeline)) {
            return false;
        }
        InstanceFleetTimeline other = (InstanceFleetTimeline) obj;
        return Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(readyDateTime(), other.readyDateTime()) && Objects.equals(endDateTime(), other.endDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InstanceFleetTimeline").add("CreationDateTime", creationDateTime())
                .add("ReadyDateTime", readyDateTime()).add("EndDateTime", endDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "ReadyDateTime":
            return Optional.ofNullable(clazz.cast(readyDateTime()));
        case "EndDateTime":
            return Optional.ofNullable(clazz.cast(endDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceFleetTimeline, T> g) {
        return obj -> g.apply((InstanceFleetTimeline) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceFleetTimeline> {
        /**
         * <p>
         * The time and date the instance fleet was created.
         * </p>
         * 
         * @param creationDateTime
         *        The time and date the instance fleet was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The time and date the instance fleet was ready to run jobs.
         * </p>
         * 
         * @param readyDateTime
         *        The time and date the instance fleet was ready to run jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readyDateTime(Instant readyDateTime);

        /**
         * <p>
         * The time and date the instance fleet terminated.
         * </p>
         * 
         * @param endDateTime
         *        The time and date the instance fleet terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDateTime(Instant endDateTime);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationDateTime;

        private Instant readyDateTime;

        private Instant endDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceFleetTimeline model) {
            creationDateTime(model.creationDateTime);
            readyDateTime(model.readyDateTime);
            endDateTime(model.endDateTime);
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final Instant getReadyDateTime() {
            return readyDateTime;
        }

        @Override
        public final Builder readyDateTime(Instant readyDateTime) {
            this.readyDateTime = readyDateTime;
            return this;
        }

        public final void setReadyDateTime(Instant readyDateTime) {
            this.readyDateTime = readyDateTime;
        }

        public final Instant getEndDateTime() {
            return endDateTime;
        }

        @Override
        public final Builder endDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final void setEndDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        public InstanceFleetTimeline build() {
            return new InstanceFleetTimeline(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
