/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.StepSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StepSummaryMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Config").isBinary(false).build();
    private static final MarshallingInfo<String> ACTIONONFAILURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActionOnFailure").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final StepSummaryMarshaller INSTANCE = new StepSummaryMarshaller();

    private StepSummaryMarshaller() {
    }

    public static StepSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StepSummary stepSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)stepSummary, (String)"stepSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)stepSummary.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)stepSummary.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)stepSummary.config(), CONFIG_BINDING);
            protocolMarshaller.marshall((Object)stepSummary.actionOnFailureString(), ACTIONONFAILURE_BINDING);
            protocolMarshaller.marshall((Object)stepSummary.status(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

