/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.RunJobFlowRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RunJobFlowRequestModelMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> LOGURI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogUri").isBinary(false).build();
    private static final MarshallingInfo<String> ADDITIONALINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdditionalInfo").isBinary(false).build();
    private static final MarshallingInfo<String> AMIVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AmiVersion").isBinary(false).build();
    private static final MarshallingInfo<String> RELEASELABEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReleaseLabel").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INSTANCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Instances").isBinary(false).build();
    private static final MarshallingInfo<List> STEPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Steps").isBinary(false).build();
    private static final MarshallingInfo<List> BOOTSTRAPACTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BootstrapActions").isBinary(false).build();
    private static final MarshallingInfo<List> SUPPORTEDPRODUCTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportedProducts").isBinary(false).build();
    private static final MarshallingInfo<List> NEWSUPPORTEDPRODUCTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NewSupportedProducts").isBinary(false).build();
    private static final MarshallingInfo<List> APPLICATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Applications").isBinary(false).build();
    private static final MarshallingInfo<List> CONFIGURATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Configurations").isBinary(false).build();
    private static final MarshallingInfo<Boolean> VISIBLETOALLUSERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VisibleToAllUsers").isBinary(false).build();
    private static final MarshallingInfo<String> JOBFLOWROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobFlowRole").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICEROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceRole").isBinary(false).build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").isBinary(false).build();
    private static final MarshallingInfo<String> SECURITYCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityConfiguration").isBinary(false).build();
    private static final MarshallingInfo<String> AUTOSCALINGROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoScalingRole").isBinary(false).build();
    private static final MarshallingInfo<String> SCALEDOWNBEHAVIOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScaleDownBehavior").isBinary(false).build();
    private static final MarshallingInfo<String> CUSTOMAMIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomAmiId").isBinary(false).build();
    private static final MarshallingInfo<Integer> EBSROOTVOLUMESIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EbsRootVolumeSize").isBinary(false).build();
    private static final MarshallingInfo<String> REPOUPGRADEONBOOT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RepoUpgradeOnBoot").isBinary(false).build();
    private static final RunJobFlowRequestModelMarshaller INSTANCE = new RunJobFlowRequestModelMarshaller();

    private RunJobFlowRequestModelMarshaller() {
    }

    public static RunJobFlowRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RunJobFlowRequest runJobFlowRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)runJobFlowRequest), (String)"runJobFlowRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)runJobFlowRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)runJobFlowRequest.logUri(), LOGURI_BINDING);
            protocolMarshaller.marshall((Object)runJobFlowRequest.additionalInfo(), ADDITIONALINFO_BINDING);
            protocolMarshaller.marshall((Object)runJobFlowRequest.amiVersion(), AMIVERSION_BINDING);
            protocolMarshaller.marshall((Object)runJobFlowRequest.releaseLabel(), RELEASELABEL_BINDING);
            protocolMarshaller.marshall((Object)runJobFlowRequest.instances(), INSTANCES_BINDING);
            protocolMarshaller.marshall(runJobFlowRequest.steps(), STEPS_BINDING);
            protocolMarshaller.marshall(runJobFlowRequest.bootstrapActions(), BOOTSTRAPACTIONS_BINDING);
            protocolMarshaller.marshall(runJobFlowRequest.supportedProducts(), SUPPORTEDPRODUCTS_BINDING);
            protocolMarshaller.marshall(runJobFlowRequest.newSupportedProducts(), NEWSUPPORTEDPRODUCTS_BINDING);
            protocolMarshaller.marshall(runJobFlowRequest.applications(), APPLICATIONS_BINDING);
            protocolMarshaller.marshall(runJobFlowRequest.configurations(), CONFIGURATIONS_BINDING);
            protocolMarshaller.marshall((Object)runJobFlowRequest.visibleToAllUsers(), VISIBLETOALLUSERS_BINDING);
            protocolMarshaller.marshall((Object)runJobFlowRequest.jobFlowRole(), JOBFLOWROLE_BINDING);
            protocolMarshaller.marshall((Object)runJobFlowRequest.serviceRole(), SERVICEROLE_BINDING);
            protocolMarshaller.marshall(runJobFlowRequest.tags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)runJobFlowRequest.securityConfiguration(), SECURITYCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)runJobFlowRequest.autoScalingRole(), AUTOSCALINGROLE_BINDING);
            protocolMarshaller.marshall((Object)runJobFlowRequest.scaleDownBehaviorString(), SCALEDOWNBEHAVIOR_BINDING);
            protocolMarshaller.marshall((Object)runJobFlowRequest.customAmiId(), CUSTOMAMIID_BINDING);
            protocolMarshaller.marshall((Object)runJobFlowRequest.ebsRootVolumeSize(), EBSROOTVOLUMESIZE_BINDING);
            protocolMarshaller.marshall((Object)runJobFlowRequest.repoUpgradeOnBootString(), REPOUPGRADEONBOOT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

