/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.ListStepsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListStepsRequestModelMarshaller {
    private static final MarshallingInfo<String> CLUSTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterId").isBinary(false).build();
    private static final MarshallingInfo<List> STEPSTATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StepStates").isBinary(false).build();
    private static final MarshallingInfo<List> STEPIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StepIds").isBinary(false).build();
    private static final MarshallingInfo<String> MARKER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Marker").isBinary(false).build();
    private static final ListStepsRequestModelMarshaller INSTANCE = new ListStepsRequestModelMarshaller();

    private ListStepsRequestModelMarshaller() {
    }

    public static ListStepsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListStepsRequest listStepsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listStepsRequest), (String)"listStepsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listStepsRequest.clusterId(), CLUSTERID_BINDING);
            protocolMarshaller.marshall(listStepsRequest.stepStatesStrings(), STEPSTATES_BINDING);
            protocolMarshaller.marshall(listStepsRequest.stepIds(), STEPIDS_BINDING);
            protocolMarshaller.marshall((Object)listStepsRequest.marker(), MARKER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

