/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.JobFlowDetail;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class JobFlowDetailMarshaller {
    private static final MarshallingInfo<String> JOBFLOWID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobFlowId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> LOGURI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogUri").isBinary(false).build();
    private static final MarshallingInfo<String> AMIVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AmiVersion").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EXECUTIONSTATUSDETAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionStatusDetail").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> INSTANCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Instances").isBinary(false).build();
    private static final MarshallingInfo<List> STEPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Steps").isBinary(false).build();
    private static final MarshallingInfo<List> BOOTSTRAPACTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BootstrapActions").isBinary(false).build();
    private static final MarshallingInfo<List> SUPPORTEDPRODUCTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportedProducts").isBinary(false).build();
    private static final MarshallingInfo<Boolean> VISIBLETOALLUSERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VisibleToAllUsers").isBinary(false).build();
    private static final MarshallingInfo<String> JOBFLOWROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobFlowRole").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICEROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceRole").isBinary(false).build();
    private static final MarshallingInfo<String> AUTOSCALINGROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoScalingRole").isBinary(false).build();
    private static final MarshallingInfo<String> SCALEDOWNBEHAVIOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScaleDownBehavior").isBinary(false).build();
    private static final JobFlowDetailMarshaller INSTANCE = new JobFlowDetailMarshaller();

    private JobFlowDetailMarshaller() {
    }

    public static JobFlowDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobFlowDetail jobFlowDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)jobFlowDetail, (String)"jobFlowDetail");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)jobFlowDetail.jobFlowId(), JOBFLOWID_BINDING);
            protocolMarshaller.marshall((Object)jobFlowDetail.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)jobFlowDetail.logUri(), LOGURI_BINDING);
            protocolMarshaller.marshall((Object)jobFlowDetail.amiVersion(), AMIVERSION_BINDING);
            protocolMarshaller.marshall((Object)jobFlowDetail.executionStatusDetail(), EXECUTIONSTATUSDETAIL_BINDING);
            protocolMarshaller.marshall((Object)jobFlowDetail.instances(), INSTANCES_BINDING);
            protocolMarshaller.marshall(jobFlowDetail.steps(), STEPS_BINDING);
            protocolMarshaller.marshall(jobFlowDetail.bootstrapActions(), BOOTSTRAPACTIONS_BINDING);
            protocolMarshaller.marshall(jobFlowDetail.supportedProducts(), SUPPORTEDPRODUCTS_BINDING);
            protocolMarshaller.marshall((Object)jobFlowDetail.visibleToAllUsers(), VISIBLETOALLUSERS_BINDING);
            protocolMarshaller.marshall((Object)jobFlowDetail.jobFlowRole(), JOBFLOWROLE_BINDING);
            protocolMarshaller.marshall((Object)jobFlowDetail.serviceRole(), SERVICEROLE_BINDING);
            protocolMarshaller.marshall((Object)jobFlowDetail.autoScalingRole(), AUTOSCALINGROLE_BINDING);
            protocolMarshaller.marshall((Object)jobFlowDetail.scaleDownBehaviorString(), SCALEDOWNBEHAVIOR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

