/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.InstanceStatus;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InstanceStatusMarshaller {
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STATECHANGEREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateChangeReason").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TIMELINE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timeline").isBinary(false).build();
    private static final InstanceStatusMarshaller INSTANCE = new InstanceStatusMarshaller();

    private InstanceStatusMarshaller() {
    }

    public static InstanceStatusMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceStatus instanceStatus, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)instanceStatus, (String)"instanceStatus");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)instanceStatus.stateString(), STATE_BINDING);
            protocolMarshaller.marshall((Object)instanceStatus.stateChangeReason(), STATECHANGEREASON_BINDING);
            protocolMarshaller.marshall((Object)instanceStatus.timeline(), TIMELINE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

