/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.InstanceResizePolicy;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InstanceResizePolicyMarshaller {
    private static final MarshallingInfo<List> INSTANCESTOTERMINATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstancesToTerminate").isBinary(false).build();
    private static final MarshallingInfo<List> INSTANCESTOPROTECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstancesToProtect").isBinary(false).build();
    private static final MarshallingInfo<Integer> INSTANCETERMINATIONTIMEOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceTerminationTimeout").isBinary(false).build();
    private static final InstanceResizePolicyMarshaller INSTANCE = new InstanceResizePolicyMarshaller();

    private InstanceResizePolicyMarshaller() {
    }

    public static InstanceResizePolicyMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceResizePolicy instanceResizePolicy, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)instanceResizePolicy, (String)"instanceResizePolicy");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(instanceResizePolicy.instancesToTerminate(), INSTANCESTOTERMINATE_BINDING);
            protocolMarshaller.marshall(instanceResizePolicy.instancesToProtect(), INSTANCESTOPROTECT_BINDING);
            protocolMarshaller.marshall((Object)instanceResizePolicy.instanceTerminationTimeout(), INSTANCETERMINATIONTIMEOUT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

