/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.HadoopJarStepConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HadoopJarStepConfigMarshaller {
    private static final MarshallingInfo<List> PROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Properties").isBinary(false).build();
    private static final MarshallingInfo<String> JAR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Jar").isBinary(false).build();
    private static final MarshallingInfo<String> MAINCLASS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MainClass").isBinary(false).build();
    private static final MarshallingInfo<List> ARGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Args").isBinary(false).build();
    private static final HadoopJarStepConfigMarshaller INSTANCE = new HadoopJarStepConfigMarshaller();

    private HadoopJarStepConfigMarshaller() {
    }

    public static HadoopJarStepConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HadoopJarStepConfig hadoopJarStepConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)hadoopJarStepConfig, (String)"hadoopJarStepConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(hadoopJarStepConfig.properties(), PROPERTIES_BINDING);
            protocolMarshaller.marshall((Object)hadoopJarStepConfig.jar(), JAR_BINDING);
            protocolMarshaller.marshall((Object)hadoopJarStepConfig.mainClass(), MAINCLASS_BINDING);
            protocolMarshaller.marshall(hadoopJarStepConfig.args(), ARGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

