/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.DescribeStepRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeStepRequestModelMarshaller {
    private static final MarshallingInfo<String> CLUSTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterId").isBinary(false).build();
    private static final MarshallingInfo<String> STEPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StepId").isBinary(false).build();
    private static final DescribeStepRequestModelMarshaller INSTANCE = new DescribeStepRequestModelMarshaller();

    private DescribeStepRequestModelMarshaller() {
    }

    public static DescribeStepRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeStepRequest describeStepRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeStepRequest), (String)"describeStepRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)describeStepRequest.clusterId(), CLUSTERID_BINDING);
            protocolMarshaller.marshall((Object)describeStepRequest.stepId(), STEPID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

