/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.emr.EMRClient;
import software.amazon.awssdk.services.emr.model.Instance;
import software.amazon.awssdk.services.emr.model.ListInstancesRequest;
import software.amazon.awssdk.services.emr.model.ListInstancesResponse;

public class ListInstancesIterable
implements SdkIterable<ListInstancesResponse> {
    private final EMRClient client;
    private final ListInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInstancesIterable(EMRClient client, ListInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInstancesResponseFetcher();
    }

    public Iterator<ListInstancesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Instance> instances() {
        Function<ListInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.instances() != null) {
                return response.instances().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListInstancesIterable resume(ListInstancesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListInstancesIterable(this.client, (ListInstancesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListInstancesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListInstancesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListInstancesResponseFetcher
    implements SyncPageFetcher<ListInstancesResponse> {
        private ListInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListInstancesResponse previousPage) {
            return previousPage.marker() != null;
        }

        public ListInstancesResponse nextPage(ListInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListInstancesIterable.this.client.listInstances(ListInstancesIterable.this.firstRequest);
            }
            return ListInstancesIterable.this.client.listInstances((ListInstancesRequest)((Object)ListInstancesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

