/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.emr.EMRAsyncClient;
import software.amazon.awssdk.services.emr.model.InstanceGroup;
import software.amazon.awssdk.services.emr.model.ListInstanceGroupsRequest;
import software.amazon.awssdk.services.emr.model.ListInstanceGroupsResponse;

public class ListInstanceGroupsPublisher
implements SdkPublisher<ListInstanceGroupsResponse> {
    private final EMRAsyncClient client;
    private final ListInstanceGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInstanceGroupsPublisher(EMRAsyncClient client, ListInstanceGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInstanceGroupsPublisher(EMRAsyncClient client, ListInstanceGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInstanceGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInstanceGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<InstanceGroup> instanceGroups() {
        Function<ListInstanceGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceGroups() != null) {
                return response.instanceGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListInstanceGroupsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListInstanceGroupsPublisher resume(ListInstanceGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListInstanceGroupsPublisher(this.client, (ListInstanceGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListInstanceGroupsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListInstanceGroupsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListInstanceGroupsResponseFetcher
    implements AsyncPageFetcher<ListInstanceGroupsResponse> {
        private ListInstanceGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListInstanceGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<ListInstanceGroupsResponse> nextPage(ListInstanceGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListInstanceGroupsPublisher.this.client.listInstanceGroups(ListInstanceGroupsPublisher.this.firstRequest);
            }
            return ListInstanceGroupsPublisher.this.client.listInstanceGroups((ListInstanceGroupsRequest)((Object)ListInstanceGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

