/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.emr.EMRClient;
import software.amazon.awssdk.services.emr.model.Command;
import software.amazon.awssdk.services.emr.model.ListBootstrapActionsRequest;
import software.amazon.awssdk.services.emr.model.ListBootstrapActionsResponse;

public class ListBootstrapActionsIterable
implements SdkIterable<ListBootstrapActionsResponse> {
    private final EMRClient client;
    private final ListBootstrapActionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBootstrapActionsIterable(EMRClient client, ListBootstrapActionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListBootstrapActionsResponseFetcher();
    }

    public Iterator<ListBootstrapActionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Command> bootstrapActions() {
        Function<ListBootstrapActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.bootstrapActions() != null) {
                return response.bootstrapActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListBootstrapActionsIterable resume(ListBootstrapActionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListBootstrapActionsIterable(this.client, (ListBootstrapActionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListBootstrapActionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListBootstrapActionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListBootstrapActionsResponseFetcher
    implements SyncPageFetcher<ListBootstrapActionsResponse> {
        private ListBootstrapActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListBootstrapActionsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public ListBootstrapActionsResponse nextPage(ListBootstrapActionsResponse previousPage) {
            if (previousPage == null) {
                return ListBootstrapActionsIterable.this.client.listBootstrapActions(ListBootstrapActionsIterable.this.firstRequest);
            }
            return ListBootstrapActionsIterable.this.client.listBootstrapActions((ListBootstrapActionsRequest)((Object)ListBootstrapActionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

