/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.StepConfig;
import software.amazon.awssdk.services.emr.model.StepExecutionStatusDetail;
import software.amazon.awssdk.services.emr.transform.StepDetailMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StepDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, StepDetail> {
    private final StepConfig stepConfig;
    private final StepExecutionStatusDetail executionStatusDetail;

    private StepDetail(BuilderImpl builder) {
        this.stepConfig = builder.stepConfig;
        this.executionStatusDetail = builder.executionStatusDetail;
    }

    public StepConfig stepConfig() {
        return this.stepConfig;
    }

    public StepExecutionStatusDetail executionStatusDetail() {
        return this.executionStatusDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stepConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStatusDetail());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepDetail)) {
            return false;
        }
        StepDetail other = (StepDetail)obj;
        return Objects.equals(this.stepConfig(), other.stepConfig()) && Objects.equals(this.executionStatusDetail(), other.executionStatusDetail());
    }

    public String toString() {
        return ToString.builder((String)"StepDetail").add("StepConfig", (Object)this.stepConfig()).add("ExecutionStatusDetail", (Object)this.executionStatusDetail()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StepConfig": {
                return Optional.of(clazz.cast(this.stepConfig()));
            }
            case "ExecutionStatusDetail": {
                return Optional.of(clazz.cast(this.executionStatusDetail()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StepDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private StepConfig stepConfig;
        private StepExecutionStatusDetail executionStatusDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(StepDetail model) {
            this.stepConfig(model.stepConfig);
            this.executionStatusDetail(model.executionStatusDetail);
        }

        public final StepConfig.Builder getStepConfig() {
            return this.stepConfig != null ? this.stepConfig.toBuilder() : null;
        }

        @Override
        public final Builder stepConfig(StepConfig stepConfig) {
            this.stepConfig = stepConfig;
            return this;
        }

        public final void setStepConfig(StepConfig.BuilderImpl stepConfig) {
            this.stepConfig = stepConfig != null ? stepConfig.build() : null;
        }

        public final StepExecutionStatusDetail.Builder getExecutionStatusDetail() {
            return this.executionStatusDetail != null ? this.executionStatusDetail.toBuilder() : null;
        }

        @Override
        public final Builder executionStatusDetail(StepExecutionStatusDetail executionStatusDetail) {
            this.executionStatusDetail = executionStatusDetail;
            return this;
        }

        public final void setExecutionStatusDetail(StepExecutionStatusDetail.BuilderImpl executionStatusDetail) {
            this.executionStatusDetail = executionStatusDetail != null ? executionStatusDetail.build() : null;
        }

        public StepDetail build() {
            return new StepDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StepDetail> {
        public Builder stepConfig(StepConfig var1);

        default public Builder stepConfig(Consumer<StepConfig.Builder> stepConfig) {
            return this.stepConfig((StepConfig)((StepConfig.Builder)StepConfig.builder().apply(stepConfig)).build());
        }

        public Builder executionStatusDetail(StepExecutionStatusDetail var1);

        default public Builder executionStatusDetail(Consumer<StepExecutionStatusDetail.Builder> executionStatusDetail) {
            return this.executionStatusDetail((StepExecutionStatusDetail)((StepExecutionStatusDetail.Builder)StepExecutionStatusDetail.builder().apply(executionStatusDetail)).build());
        }
    }
}

