/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.EbsVolume;
import software.amazon.awssdk.services.emr.model.EbsVolumeListCopier;
import software.amazon.awssdk.services.emr.model.InstanceStatus;
import software.amazon.awssdk.services.emr.model.MarketType;
import software.amazon.awssdk.services.emr.transform.InstanceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Instance
implements StructuredPojo,
ToCopyableBuilder<Builder, Instance> {
    private final String id;
    private final String ec2InstanceId;
    private final String publicDnsName;
    private final String publicIpAddress;
    private final String privateDnsName;
    private final String privateIpAddress;
    private final InstanceStatus status;
    private final String instanceGroupId;
    private final String instanceFleetId;
    private final String market;
    private final String instanceType;
    private final List<EbsVolume> ebsVolumes;

    private Instance(BuilderImpl builder) {
        this.id = builder.id;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.publicDnsName = builder.publicDnsName;
        this.publicIpAddress = builder.publicIpAddress;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
        this.status = builder.status;
        this.instanceGroupId = builder.instanceGroupId;
        this.instanceFleetId = builder.instanceFleetId;
        this.market = builder.market;
        this.instanceType = builder.instanceType;
        this.ebsVolumes = builder.ebsVolumes;
    }

    public String id() {
        return this.id;
    }

    public String ec2InstanceId() {
        return this.ec2InstanceId;
    }

    public String publicDnsName() {
        return this.publicDnsName;
    }

    public String publicIpAddress() {
        return this.publicIpAddress;
    }

    public String privateDnsName() {
        return this.privateDnsName;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public InstanceStatus status() {
        return this.status;
    }

    public String instanceGroupId() {
        return this.instanceGroupId;
    }

    public String instanceFleetId() {
        return this.instanceFleetId;
    }

    public MarketType market() {
        return MarketType.fromValue(this.market);
    }

    public String marketString() {
        return this.market;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public List<EbsVolume> ebsVolumes() {
        return this.ebsVolumes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.marketString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsVolumes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.ec2InstanceId(), other.ec2InstanceId()) && Objects.equals(this.publicDnsName(), other.publicDnsName()) && Objects.equals(this.publicIpAddress(), other.publicIpAddress()) && Objects.equals(this.privateDnsName(), other.privateDnsName()) && Objects.equals(this.privateIpAddress(), other.privateIpAddress()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.instanceGroupId(), other.instanceGroupId()) && Objects.equals(this.instanceFleetId(), other.instanceFleetId()) && Objects.equals(this.marketString(), other.marketString()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.ebsVolumes(), other.ebsVolumes());
    }

    public String toString() {
        return ToString.builder((String)"Instance").add("Id", (Object)this.id()).add("Ec2InstanceId", (Object)this.ec2InstanceId()).add("PublicDnsName", (Object)this.publicDnsName()).add("PublicIpAddress", (Object)this.publicIpAddress()).add("PrivateDnsName", (Object)this.privateDnsName()).add("PrivateIpAddress", (Object)this.privateIpAddress()).add("Status", (Object)this.status()).add("InstanceGroupId", (Object)this.instanceGroupId()).add("InstanceFleetId", (Object)this.instanceFleetId()).add("Market", (Object)this.marketString()).add("InstanceType", (Object)this.instanceType()).add("EbsVolumes", this.ebsVolumes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Ec2InstanceId": {
                return Optional.of(clazz.cast(this.ec2InstanceId()));
            }
            case "PublicDnsName": {
                return Optional.of(clazz.cast(this.publicDnsName()));
            }
            case "PublicIpAddress": {
                return Optional.of(clazz.cast(this.publicIpAddress()));
            }
            case "PrivateDnsName": {
                return Optional.of(clazz.cast(this.privateDnsName()));
            }
            case "PrivateIpAddress": {
                return Optional.of(clazz.cast(this.privateIpAddress()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "InstanceGroupId": {
                return Optional.of(clazz.cast(this.instanceGroupId()));
            }
            case "InstanceFleetId": {
                return Optional.of(clazz.cast(this.instanceFleetId()));
            }
            case "Market": {
                return Optional.of(clazz.cast(this.marketString()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceType()));
            }
            case "EbsVolumes": {
                return Optional.of(clazz.cast(this.ebsVolumes()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String ec2InstanceId;
        private String publicDnsName;
        private String publicIpAddress;
        private String privateDnsName;
        private String privateIpAddress;
        private InstanceStatus status;
        private String instanceGroupId;
        private String instanceFleetId;
        private String market;
        private String instanceType;
        private List<EbsVolume> ebsVolumes;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            this.id(model.id);
            this.ec2InstanceId(model.ec2InstanceId);
            this.publicDnsName(model.publicDnsName);
            this.publicIpAddress(model.publicIpAddress);
            this.privateDnsName(model.privateDnsName);
            this.privateIpAddress(model.privateIpAddress);
            this.status(model.status);
            this.instanceGroupId(model.instanceGroupId);
            this.instanceFleetId(model.instanceFleetId);
            this.market(model.market);
            this.instanceType(model.instanceType);
            this.ebsVolumes(model.ebsVolumes);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getEc2InstanceId() {
            return this.ec2InstanceId;
        }

        @Override
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        public final String getPublicDnsName() {
            return this.publicDnsName;
        }

        @Override
        public final Builder publicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
            return this;
        }

        public final void setPublicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
        }

        public final String getPublicIpAddress() {
            return this.publicIpAddress;
        }

        @Override
        public final Builder publicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
            return this;
        }

        public final void setPublicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
        }

        public final String getPrivateDnsName() {
            return this.privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final InstanceStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(InstanceStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(InstanceStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final String getInstanceGroupId() {
            return this.instanceGroupId;
        }

        @Override
        public final Builder instanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
            return this;
        }

        public final void setInstanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
        }

        public final String getInstanceFleetId() {
            return this.instanceFleetId;
        }

        @Override
        public final Builder instanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
            return this;
        }

        public final void setInstanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
        }

        public final String getMarket() {
            return this.market;
        }

        @Override
        public final Builder market(String market) {
            this.market = market;
            return this;
        }

        @Override
        public final Builder market(MarketType market) {
            this.market(market.toString());
            return this;
        }

        public final void setMarket(String market) {
            this.market = market;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Collection<EbsVolume.Builder> getEbsVolumes() {
            return this.ebsVolumes != null ? (Collection)this.ebsVolumes.stream().map(EbsVolume::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ebsVolumes(Collection<EbsVolume> ebsVolumes) {
            this.ebsVolumes = EbsVolumeListCopier.copy(ebsVolumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ebsVolumes(EbsVolume ... ebsVolumes) {
            this.ebsVolumes(Arrays.asList(ebsVolumes));
            return this;
        }

        public final void setEbsVolumes(Collection<EbsVolume.BuilderImpl> ebsVolumes) {
            this.ebsVolumes = EbsVolumeListCopier.copyFromBuilder(ebsVolumes);
        }

        public Instance build() {
            return new Instance(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Instance> {
        public Builder id(String var1);

        public Builder ec2InstanceId(String var1);

        public Builder publicDnsName(String var1);

        public Builder publicIpAddress(String var1);

        public Builder privateDnsName(String var1);

        public Builder privateIpAddress(String var1);

        public Builder status(InstanceStatus var1);

        default public Builder status(Consumer<InstanceStatus.Builder> status) {
            return this.status((InstanceStatus)((InstanceStatus.Builder)InstanceStatus.builder().apply(status)).build());
        }

        public Builder instanceGroupId(String var1);

        public Builder instanceFleetId(String var1);

        public Builder market(String var1);

        public Builder market(MarketType var1);

        public Builder instanceType(String var1);

        public Builder ebsVolumes(Collection<EbsVolume> var1);

        public Builder ebsVolumes(EbsVolume ... var1);
    }
}

