/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.Application;
import software.amazon.awssdk.services.emr.model.ApplicationListCopier;
import software.amazon.awssdk.services.emr.model.ClusterStatus;
import software.amazon.awssdk.services.emr.model.Configuration;
import software.amazon.awssdk.services.emr.model.ConfigurationListCopier;
import software.amazon.awssdk.services.emr.model.Ec2InstanceAttributes;
import software.amazon.awssdk.services.emr.model.InstanceCollectionType;
import software.amazon.awssdk.services.emr.model.RepoUpgradeOnBoot;
import software.amazon.awssdk.services.emr.model.ScaleDownBehavior;
import software.amazon.awssdk.services.emr.model.Tag;
import software.amazon.awssdk.services.emr.model.TagListCopier;
import software.amazon.awssdk.services.emr.transform.ClusterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Cluster
implements StructuredPojo,
ToCopyableBuilder<Builder, Cluster> {
    private final String id;
    private final String name;
    private final ClusterStatus status;
    private final Ec2InstanceAttributes ec2InstanceAttributes;
    private final String instanceCollectionType;
    private final String logUri;
    private final String requestedAmiVersion;
    private final String runningAmiVersion;
    private final String releaseLabel;
    private final Boolean autoTerminate;
    private final Boolean terminationProtected;
    private final Boolean visibleToAllUsers;
    private final List<Application> applications;
    private final List<Tag> tags;
    private final String serviceRole;
    private final Integer normalizedInstanceHours;
    private final String masterPublicDnsName;
    private final List<Configuration> configurations;
    private final String securityConfiguration;
    private final String autoScalingRole;
    private final String scaleDownBehavior;
    private final String customAmiId;
    private final Integer ebsRootVolumeSize;
    private final String repoUpgradeOnBoot;

    private Cluster(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
        this.ec2InstanceAttributes = builder.ec2InstanceAttributes;
        this.instanceCollectionType = builder.instanceCollectionType;
        this.logUri = builder.logUri;
        this.requestedAmiVersion = builder.requestedAmiVersion;
        this.runningAmiVersion = builder.runningAmiVersion;
        this.releaseLabel = builder.releaseLabel;
        this.autoTerminate = builder.autoTerminate;
        this.terminationProtected = builder.terminationProtected;
        this.visibleToAllUsers = builder.visibleToAllUsers;
        this.applications = builder.applications;
        this.tags = builder.tags;
        this.serviceRole = builder.serviceRole;
        this.normalizedInstanceHours = builder.normalizedInstanceHours;
        this.masterPublicDnsName = builder.masterPublicDnsName;
        this.configurations = builder.configurations;
        this.securityConfiguration = builder.securityConfiguration;
        this.autoScalingRole = builder.autoScalingRole;
        this.scaleDownBehavior = builder.scaleDownBehavior;
        this.customAmiId = builder.customAmiId;
        this.ebsRootVolumeSize = builder.ebsRootVolumeSize;
        this.repoUpgradeOnBoot = builder.repoUpgradeOnBoot;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public ClusterStatus status() {
        return this.status;
    }

    public Ec2InstanceAttributes ec2InstanceAttributes() {
        return this.ec2InstanceAttributes;
    }

    public InstanceCollectionType instanceCollectionType() {
        return InstanceCollectionType.fromValue(this.instanceCollectionType);
    }

    public String instanceCollectionTypeString() {
        return this.instanceCollectionType;
    }

    public String logUri() {
        return this.logUri;
    }

    public String requestedAmiVersion() {
        return this.requestedAmiVersion;
    }

    public String runningAmiVersion() {
        return this.runningAmiVersion;
    }

    public String releaseLabel() {
        return this.releaseLabel;
    }

    public Boolean autoTerminate() {
        return this.autoTerminate;
    }

    public Boolean terminationProtected() {
        return this.terminationProtected;
    }

    public Boolean visibleToAllUsers() {
        return this.visibleToAllUsers;
    }

    public List<Application> applications() {
        return this.applications;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    public Integer normalizedInstanceHours() {
        return this.normalizedInstanceHours;
    }

    public String masterPublicDnsName() {
        return this.masterPublicDnsName;
    }

    public List<Configuration> configurations() {
        return this.configurations;
    }

    public String securityConfiguration() {
        return this.securityConfiguration;
    }

    public String autoScalingRole() {
        return this.autoScalingRole;
    }

    public ScaleDownBehavior scaleDownBehavior() {
        return ScaleDownBehavior.fromValue(this.scaleDownBehavior);
    }

    public String scaleDownBehaviorString() {
        return this.scaleDownBehavior;
    }

    public String customAmiId() {
        return this.customAmiId;
    }

    public Integer ebsRootVolumeSize() {
        return this.ebsRootVolumeSize;
    }

    public RepoUpgradeOnBoot repoUpgradeOnBoot() {
        return RepoUpgradeOnBoot.fromValue(this.repoUpgradeOnBoot);
    }

    public String repoUpgradeOnBootString() {
        return this.repoUpgradeOnBoot;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCollectionTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedAmiVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.runningAmiVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoTerminate());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationProtected());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibleToAllUsers());
        hashCode = 31 * hashCode + Objects.hashCode(this.applications());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.normalizedInstanceHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterPublicDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.scaleDownBehaviorString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customAmiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsRootVolumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.repoUpgradeOnBootString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.ec2InstanceAttributes(), other.ec2InstanceAttributes()) && Objects.equals(this.instanceCollectionTypeString(), other.instanceCollectionTypeString()) && Objects.equals(this.logUri(), other.logUri()) && Objects.equals(this.requestedAmiVersion(), other.requestedAmiVersion()) && Objects.equals(this.runningAmiVersion(), other.runningAmiVersion()) && Objects.equals(this.releaseLabel(), other.releaseLabel()) && Objects.equals(this.autoTerminate(), other.autoTerminate()) && Objects.equals(this.terminationProtected(), other.terminationProtected()) && Objects.equals(this.visibleToAllUsers(), other.visibleToAllUsers()) && Objects.equals(this.applications(), other.applications()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.normalizedInstanceHours(), other.normalizedInstanceHours()) && Objects.equals(this.masterPublicDnsName(), other.masterPublicDnsName()) && Objects.equals(this.configurations(), other.configurations()) && Objects.equals(this.securityConfiguration(), other.securityConfiguration()) && Objects.equals(this.autoScalingRole(), other.autoScalingRole()) && Objects.equals(this.scaleDownBehaviorString(), other.scaleDownBehaviorString()) && Objects.equals(this.customAmiId(), other.customAmiId()) && Objects.equals(this.ebsRootVolumeSize(), other.ebsRootVolumeSize()) && Objects.equals(this.repoUpgradeOnBootString(), other.repoUpgradeOnBootString());
    }

    public String toString() {
        return ToString.builder((String)"Cluster").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Status", (Object)this.status()).add("Ec2InstanceAttributes", (Object)this.ec2InstanceAttributes()).add("InstanceCollectionType", (Object)this.instanceCollectionTypeString()).add("LogUri", (Object)this.logUri()).add("RequestedAmiVersion", (Object)this.requestedAmiVersion()).add("RunningAmiVersion", (Object)this.runningAmiVersion()).add("ReleaseLabel", (Object)this.releaseLabel()).add("AutoTerminate", (Object)this.autoTerminate()).add("TerminationProtected", (Object)this.terminationProtected()).add("VisibleToAllUsers", (Object)this.visibleToAllUsers()).add("Applications", this.applications()).add("Tags", this.tags()).add("ServiceRole", (Object)this.serviceRole()).add("NormalizedInstanceHours", (Object)this.normalizedInstanceHours()).add("MasterPublicDnsName", (Object)this.masterPublicDnsName()).add("Configurations", this.configurations()).add("SecurityConfiguration", (Object)this.securityConfiguration()).add("AutoScalingRole", (Object)this.autoScalingRole()).add("ScaleDownBehavior", (Object)this.scaleDownBehaviorString()).add("CustomAmiId", (Object)this.customAmiId()).add("EbsRootVolumeSize", (Object)this.ebsRootVolumeSize()).add("RepoUpgradeOnBoot", (Object)this.repoUpgradeOnBootString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "Ec2InstanceAttributes": {
                return Optional.of(clazz.cast(this.ec2InstanceAttributes()));
            }
            case "InstanceCollectionType": {
                return Optional.of(clazz.cast(this.instanceCollectionTypeString()));
            }
            case "LogUri": {
                return Optional.of(clazz.cast(this.logUri()));
            }
            case "RequestedAmiVersion": {
                return Optional.of(clazz.cast(this.requestedAmiVersion()));
            }
            case "RunningAmiVersion": {
                return Optional.of(clazz.cast(this.runningAmiVersion()));
            }
            case "ReleaseLabel": {
                return Optional.of(clazz.cast(this.releaseLabel()));
            }
            case "AutoTerminate": {
                return Optional.of(clazz.cast(this.autoTerminate()));
            }
            case "TerminationProtected": {
                return Optional.of(clazz.cast(this.terminationProtected()));
            }
            case "VisibleToAllUsers": {
                return Optional.of(clazz.cast(this.visibleToAllUsers()));
            }
            case "Applications": {
                return Optional.of(clazz.cast(this.applications()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "ServiceRole": {
                return Optional.of(clazz.cast(this.serviceRole()));
            }
            case "NormalizedInstanceHours": {
                return Optional.of(clazz.cast(this.normalizedInstanceHours()));
            }
            case "MasterPublicDnsName": {
                return Optional.of(clazz.cast(this.masterPublicDnsName()));
            }
            case "Configurations": {
                return Optional.of(clazz.cast(this.configurations()));
            }
            case "SecurityConfiguration": {
                return Optional.of(clazz.cast(this.securityConfiguration()));
            }
            case "AutoScalingRole": {
                return Optional.of(clazz.cast(this.autoScalingRole()));
            }
            case "ScaleDownBehavior": {
                return Optional.of(clazz.cast(this.scaleDownBehaviorString()));
            }
            case "CustomAmiId": {
                return Optional.of(clazz.cast(this.customAmiId()));
            }
            case "EbsRootVolumeSize": {
                return Optional.of(clazz.cast(this.ebsRootVolumeSize()));
            }
            case "RepoUpgradeOnBoot": {
                return Optional.of(clazz.cast(this.repoUpgradeOnBootString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClusterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private ClusterStatus status;
        private Ec2InstanceAttributes ec2InstanceAttributes;
        private String instanceCollectionType;
        private String logUri;
        private String requestedAmiVersion;
        private String runningAmiVersion;
        private String releaseLabel;
        private Boolean autoTerminate;
        private Boolean terminationProtected;
        private Boolean visibleToAllUsers;
        private List<Application> applications;
        private List<Tag> tags;
        private String serviceRole;
        private Integer normalizedInstanceHours;
        private String masterPublicDnsName;
        private List<Configuration> configurations;
        private String securityConfiguration;
        private String autoScalingRole;
        private String scaleDownBehavior;
        private String customAmiId;
        private Integer ebsRootVolumeSize;
        private String repoUpgradeOnBoot;

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            this.id(model.id);
            this.name(model.name);
            this.status(model.status);
            this.ec2InstanceAttributes(model.ec2InstanceAttributes);
            this.instanceCollectionType(model.instanceCollectionType);
            this.logUri(model.logUri);
            this.requestedAmiVersion(model.requestedAmiVersion);
            this.runningAmiVersion(model.runningAmiVersion);
            this.releaseLabel(model.releaseLabel);
            this.autoTerminate(model.autoTerminate);
            this.terminationProtected(model.terminationProtected);
            this.visibleToAllUsers(model.visibleToAllUsers);
            this.applications(model.applications);
            this.tags(model.tags);
            this.serviceRole(model.serviceRole);
            this.normalizedInstanceHours(model.normalizedInstanceHours);
            this.masterPublicDnsName(model.masterPublicDnsName);
            this.configurations(model.configurations);
            this.securityConfiguration(model.securityConfiguration);
            this.autoScalingRole(model.autoScalingRole);
            this.scaleDownBehavior(model.scaleDownBehavior);
            this.customAmiId(model.customAmiId);
            this.ebsRootVolumeSize(model.ebsRootVolumeSize);
            this.repoUpgradeOnBoot(model.repoUpgradeOnBoot);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ClusterStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(ClusterStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(ClusterStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final Ec2InstanceAttributes.Builder getEc2InstanceAttributes() {
            return this.ec2InstanceAttributes != null ? this.ec2InstanceAttributes.toBuilder() : null;
        }

        @Override
        public final Builder ec2InstanceAttributes(Ec2InstanceAttributes ec2InstanceAttributes) {
            this.ec2InstanceAttributes = ec2InstanceAttributes;
            return this;
        }

        public final void setEc2InstanceAttributes(Ec2InstanceAttributes.BuilderImpl ec2InstanceAttributes) {
            this.ec2InstanceAttributes = ec2InstanceAttributes != null ? ec2InstanceAttributes.build() : null;
        }

        public final String getInstanceCollectionType() {
            return this.instanceCollectionType;
        }

        @Override
        public final Builder instanceCollectionType(String instanceCollectionType) {
            this.instanceCollectionType = instanceCollectionType;
            return this;
        }

        @Override
        public final Builder instanceCollectionType(InstanceCollectionType instanceCollectionType) {
            this.instanceCollectionType(instanceCollectionType.toString());
            return this;
        }

        public final void setInstanceCollectionType(String instanceCollectionType) {
            this.instanceCollectionType = instanceCollectionType;
        }

        public final String getLogUri() {
            return this.logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        public final String getRequestedAmiVersion() {
            return this.requestedAmiVersion;
        }

        @Override
        public final Builder requestedAmiVersion(String requestedAmiVersion) {
            this.requestedAmiVersion = requestedAmiVersion;
            return this;
        }

        public final void setRequestedAmiVersion(String requestedAmiVersion) {
            this.requestedAmiVersion = requestedAmiVersion;
        }

        public final String getRunningAmiVersion() {
            return this.runningAmiVersion;
        }

        @Override
        public final Builder runningAmiVersion(String runningAmiVersion) {
            this.runningAmiVersion = runningAmiVersion;
            return this;
        }

        public final void setRunningAmiVersion(String runningAmiVersion) {
            this.runningAmiVersion = runningAmiVersion;
        }

        public final String getReleaseLabel() {
            return this.releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        public final Boolean getAutoTerminate() {
            return this.autoTerminate;
        }

        @Override
        public final Builder autoTerminate(Boolean autoTerminate) {
            this.autoTerminate = autoTerminate;
            return this;
        }

        public final void setAutoTerminate(Boolean autoTerminate) {
            this.autoTerminate = autoTerminate;
        }

        public final Boolean getTerminationProtected() {
            return this.terminationProtected;
        }

        @Override
        public final Builder terminationProtected(Boolean terminationProtected) {
            this.terminationProtected = terminationProtected;
            return this;
        }

        public final void setTerminationProtected(Boolean terminationProtected) {
            this.terminationProtected = terminationProtected;
        }

        public final Boolean getVisibleToAllUsers() {
            return this.visibleToAllUsers;
        }

        @Override
        public final Builder visibleToAllUsers(Boolean visibleToAllUsers) {
            this.visibleToAllUsers = visibleToAllUsers;
            return this;
        }

        public final void setVisibleToAllUsers(Boolean visibleToAllUsers) {
            this.visibleToAllUsers = visibleToAllUsers;
        }

        public final Collection<Application.Builder> getApplications() {
            return this.applications != null ? (Collection)this.applications.stream().map(Application::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder applications(Collection<Application> applications) {
            this.applications = ApplicationListCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Application ... applications) {
            this.applications(Arrays.asList(applications));
            return this;
        }

        public final void setApplications(Collection<Application.BuilderImpl> applications) {
            this.applications = ApplicationListCopier.copyFromBuilder(applications);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final Integer getNormalizedInstanceHours() {
            return this.normalizedInstanceHours;
        }

        @Override
        public final Builder normalizedInstanceHours(Integer normalizedInstanceHours) {
            this.normalizedInstanceHours = normalizedInstanceHours;
            return this;
        }

        public final void setNormalizedInstanceHours(Integer normalizedInstanceHours) {
            this.normalizedInstanceHours = normalizedInstanceHours;
        }

        public final String getMasterPublicDnsName() {
            return this.masterPublicDnsName;
        }

        @Override
        public final Builder masterPublicDnsName(String masterPublicDnsName) {
            this.masterPublicDnsName = masterPublicDnsName;
            return this;
        }

        public final void setMasterPublicDnsName(String masterPublicDnsName) {
            this.masterPublicDnsName = masterPublicDnsName;
        }

        public final Collection<Configuration.Builder> getConfigurations() {
            return this.configurations != null ? (Collection)this.configurations.stream().map(Configuration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurations(Collection<Configuration> configurations) {
            this.configurations = ConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Configuration ... configurations) {
            this.configurations(Arrays.asList(configurations));
            return this;
        }

        public final void setConfigurations(Collection<Configuration.BuilderImpl> configurations) {
            this.configurations = ConfigurationListCopier.copyFromBuilder(configurations);
        }

        public final String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        public final String getAutoScalingRole() {
            return this.autoScalingRole;
        }

        @Override
        public final Builder autoScalingRole(String autoScalingRole) {
            this.autoScalingRole = autoScalingRole;
            return this;
        }

        public final void setAutoScalingRole(String autoScalingRole) {
            this.autoScalingRole = autoScalingRole;
        }

        public final String getScaleDownBehavior() {
            return this.scaleDownBehavior;
        }

        @Override
        public final Builder scaleDownBehavior(String scaleDownBehavior) {
            this.scaleDownBehavior = scaleDownBehavior;
            return this;
        }

        @Override
        public final Builder scaleDownBehavior(ScaleDownBehavior scaleDownBehavior) {
            this.scaleDownBehavior(scaleDownBehavior.toString());
            return this;
        }

        public final void setScaleDownBehavior(String scaleDownBehavior) {
            this.scaleDownBehavior = scaleDownBehavior;
        }

        public final String getCustomAmiId() {
            return this.customAmiId;
        }

        @Override
        public final Builder customAmiId(String customAmiId) {
            this.customAmiId = customAmiId;
            return this;
        }

        public final void setCustomAmiId(String customAmiId) {
            this.customAmiId = customAmiId;
        }

        public final Integer getEbsRootVolumeSize() {
            return this.ebsRootVolumeSize;
        }

        @Override
        public final Builder ebsRootVolumeSize(Integer ebsRootVolumeSize) {
            this.ebsRootVolumeSize = ebsRootVolumeSize;
            return this;
        }

        public final void setEbsRootVolumeSize(Integer ebsRootVolumeSize) {
            this.ebsRootVolumeSize = ebsRootVolumeSize;
        }

        public final String getRepoUpgradeOnBoot() {
            return this.repoUpgradeOnBoot;
        }

        @Override
        public final Builder repoUpgradeOnBoot(String repoUpgradeOnBoot) {
            this.repoUpgradeOnBoot = repoUpgradeOnBoot;
            return this;
        }

        @Override
        public final Builder repoUpgradeOnBoot(RepoUpgradeOnBoot repoUpgradeOnBoot) {
            this.repoUpgradeOnBoot(repoUpgradeOnBoot.toString());
            return this;
        }

        public final void setRepoUpgradeOnBoot(String repoUpgradeOnBoot) {
            this.repoUpgradeOnBoot = repoUpgradeOnBoot;
        }

        public Cluster build() {
            return new Cluster(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Cluster> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder status(ClusterStatus var1);

        default public Builder status(Consumer<ClusterStatus.Builder> status) {
            return this.status((ClusterStatus)((ClusterStatus.Builder)ClusterStatus.builder().apply(status)).build());
        }

        public Builder ec2InstanceAttributes(Ec2InstanceAttributes var1);

        default public Builder ec2InstanceAttributes(Consumer<Ec2InstanceAttributes.Builder> ec2InstanceAttributes) {
            return this.ec2InstanceAttributes((Ec2InstanceAttributes)((Ec2InstanceAttributes.Builder)Ec2InstanceAttributes.builder().apply(ec2InstanceAttributes)).build());
        }

        public Builder instanceCollectionType(String var1);

        public Builder instanceCollectionType(InstanceCollectionType var1);

        public Builder logUri(String var1);

        public Builder requestedAmiVersion(String var1);

        public Builder runningAmiVersion(String var1);

        public Builder releaseLabel(String var1);

        public Builder autoTerminate(Boolean var1);

        public Builder terminationProtected(Boolean var1);

        public Builder visibleToAllUsers(Boolean var1);

        public Builder applications(Collection<Application> var1);

        public Builder applications(Application ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder serviceRole(String var1);

        public Builder normalizedInstanceHours(Integer var1);

        public Builder masterPublicDnsName(String var1);

        public Builder configurations(Collection<Configuration> var1);

        public Builder configurations(Configuration ... var1);

        public Builder securityConfiguration(String var1);

        public Builder autoScalingRole(String var1);

        public Builder scaleDownBehavior(String var1);

        public Builder scaleDownBehavior(ScaleDownBehavior var1);

        public Builder customAmiId(String var1);

        public Builder ebsRootVolumeSize(Integer var1);

        public Builder repoUpgradeOnBoot(String var1);

        public Builder repoUpgradeOnBoot(RepoUpgradeOnBoot var1);
    }
}

