/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.AutoScalingPolicyStatus;
import software.amazon.awssdk.services.emr.model.ScalingConstraints;
import software.amazon.awssdk.services.emr.model.ScalingRule;
import software.amazon.awssdk.services.emr.model.ScalingRuleListCopier;
import software.amazon.awssdk.services.emr.transform.AutoScalingPolicyDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AutoScalingPolicyDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, AutoScalingPolicyDescription> {
    private final AutoScalingPolicyStatus status;
    private final ScalingConstraints constraints;
    private final List<ScalingRule> rules;

    private AutoScalingPolicyDescription(BuilderImpl builder) {
        this.status = builder.status;
        this.constraints = builder.constraints;
        this.rules = builder.rules;
    }

    public AutoScalingPolicyStatus status() {
        return this.status;
    }

    public ScalingConstraints constraints() {
        return this.constraints;
    }

    public List<ScalingRule> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.constraints());
        hashCode = 31 * hashCode + Objects.hashCode(this.rules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingPolicyDescription)) {
            return false;
        }
        AutoScalingPolicyDescription other = (AutoScalingPolicyDescription)obj;
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.constraints(), other.constraints()) && Objects.equals(this.rules(), other.rules());
    }

    public String toString() {
        return ToString.builder((String)"AutoScalingPolicyDescription").add("Status", (Object)this.status()).add("Constraints", (Object)this.constraints()).add("Rules", this.rules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "Constraints": {
                return Optional.of(clazz.cast(this.constraints()));
            }
            case "Rules": {
                return Optional.of(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoScalingPolicyDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private AutoScalingPolicyStatus status;
        private ScalingConstraints constraints;
        private List<ScalingRule> rules;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingPolicyDescription model) {
            this.status(model.status);
            this.constraints(model.constraints);
            this.rules(model.rules);
        }

        public final AutoScalingPolicyStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(AutoScalingPolicyStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(AutoScalingPolicyStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final ScalingConstraints.Builder getConstraints() {
            return this.constraints != null ? this.constraints.toBuilder() : null;
        }

        @Override
        public final Builder constraints(ScalingConstraints constraints) {
            this.constraints = constraints;
            return this;
        }

        public final void setConstraints(ScalingConstraints.BuilderImpl constraints) {
            this.constraints = constraints != null ? constraints.build() : null;
        }

        public final Collection<ScalingRule.Builder> getRules() {
            return this.rules != null ? (Collection)this.rules.stream().map(ScalingRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<ScalingRule> rules) {
            this.rules = ScalingRuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(ScalingRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        public final void setRules(Collection<ScalingRule.BuilderImpl> rules) {
            this.rules = ScalingRuleListCopier.copyFromBuilder(rules);
        }

        public AutoScalingPolicyDescription build() {
            return new AutoScalingPolicyDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AutoScalingPolicyDescription> {
        public Builder status(AutoScalingPolicyStatus var1);

        default public Builder status(Consumer<AutoScalingPolicyStatus.Builder> status) {
            return this.status((AutoScalingPolicyStatus)((AutoScalingPolicyStatus.Builder)AutoScalingPolicyStatus.builder().apply(status)).build());
        }

        public Builder constraints(ScalingConstraints var1);

        default public Builder constraints(Consumer<ScalingConstraints.Builder> constraints) {
            return this.constraints((ScalingConstraints)((ScalingConstraints.Builder)ScalingConstraints.builder().apply(constraints)).build());
        }

        public Builder rules(Collection<ScalingRule> var1);

        public Builder rules(ScalingRule ... var1);
    }
}

