/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.transform.VolumeSpecificationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VolumeSpecification
implements StructuredPojo,
ToCopyableBuilder<Builder, VolumeSpecification> {
    private final String volumeType;
    private final Integer iops;
    private final Integer sizeInGB;

    private VolumeSpecification(BuilderImpl builder) {
        this.volumeType = builder.volumeType;
        this.iops = builder.iops;
        this.sizeInGB = builder.sizeInGB;
    }

    public String volumeType() {
        return this.volumeType;
    }

    public Integer iops() {
        return this.iops;
    }

    public Integer sizeInGB() {
        return this.sizeInGB;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInGB());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeSpecification)) {
            return false;
        }
        VolumeSpecification other = (VolumeSpecification)obj;
        return Objects.equals(this.volumeType(), other.volumeType()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.sizeInGB(), other.sizeInGB());
    }

    public String toString() {
        return ToString.builder((String)"VolumeSpecification").add("VolumeType", (Object)this.volumeType()).add("Iops", (Object)this.iops()).add("SizeInGB", (Object)this.sizeInGB()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeType": {
                return Optional.of(clazz.cast(this.volumeType()));
            }
            case "Iops": {
                return Optional.of(clazz.cast(this.iops()));
            }
            case "SizeInGB": {
                return Optional.of(clazz.cast(this.sizeInGB()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VolumeSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String volumeType;
        private Integer iops;
        private Integer sizeInGB;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeSpecification model) {
            this.volumeType(model.volumeType);
            this.iops(model.iops);
            this.sizeInGB(model.sizeInGB);
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final Integer getSizeInGB() {
            return this.sizeInGB;
        }

        @Override
        public final Builder sizeInGB(Integer sizeInGB) {
            this.sizeInGB = sizeInGB;
            return this;
        }

        public final void setSizeInGB(Integer sizeInGB) {
            this.sizeInGB = sizeInGB;
        }

        public VolumeSpecification build() {
            return new VolumeSpecification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VolumeSpecification> {
        public Builder volumeType(String var1);

        public Builder iops(Integer var1);

        public Builder sizeInGB(Integer var1);
    }
}

