/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.emr.model.EMRResponse;
import software.amazon.awssdk.services.emr.model.InstanceFleet;
import software.amazon.awssdk.services.emr.model.InstanceFleetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListInstanceFleetsResponse
extends EMRResponse
implements ToCopyableBuilder<Builder, ListInstanceFleetsResponse> {
    private final List<InstanceFleet> instanceFleets;
    private final String marker;

    private ListInstanceFleetsResponse(BuilderImpl builder) {
        super(builder);
        this.instanceFleets = builder.instanceFleets;
        this.marker = builder.marker;
    }

    public List<InstanceFleet> instanceFleets() {
        return this.instanceFleets;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFleets());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstanceFleetsResponse)) {
            return false;
        }
        ListInstanceFleetsResponse other = (ListInstanceFleetsResponse)((Object)obj);
        return Objects.equals(this.instanceFleets(), other.instanceFleets()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListInstanceFleetsResponse").add("InstanceFleets", this.instanceFleets()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceFleets": {
                return Optional.of(clazz.cast(this.instanceFleets()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EMRResponse.BuilderImpl
    implements Builder {
        private List<InstanceFleet> instanceFleets;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstanceFleetsResponse model) {
            this.instanceFleets(model.instanceFleets);
            this.marker(model.marker);
        }

        public final Collection<InstanceFleet.Builder> getInstanceFleets() {
            return this.instanceFleets != null ? (Collection)this.instanceFleets.stream().map(InstanceFleet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceFleets(Collection<InstanceFleet> instanceFleets) {
            this.instanceFleets = InstanceFleetListCopier.copy(instanceFleets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceFleets(InstanceFleet ... instanceFleets) {
            this.instanceFleets(Arrays.asList(instanceFleets));
            return this;
        }

        public final void setInstanceFleets(Collection<InstanceFleet.BuilderImpl> instanceFleets) {
            this.instanceFleets = InstanceFleetListCopier.copyFromBuilder(instanceFleets);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListInstanceFleetsResponse build() {
            return new ListInstanceFleetsResponse(this);
        }
    }

    public static interface Builder
    extends EMRResponse.Builder,
    CopyableBuilder<Builder, ListInstanceFleetsResponse> {
        public Builder instanceFleets(Collection<InstanceFleet> var1);

        public Builder instanceFleets(InstanceFleet ... var1);

        public Builder marker(String var1);
    }
}

