/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.emr.model.ClusterState;
import software.amazon.awssdk.services.emr.model.ClusterStateListCopier;
import software.amazon.awssdk.services.emr.model.EMRRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListClustersRequest
extends EMRRequest
implements ToCopyableBuilder<Builder, ListClustersRequest> {
    private final Instant createdAfter;
    private final Instant createdBefore;
    private final List<String> clusterStates;
    private final String marker;

    private ListClustersRequest(BuilderImpl builder) {
        super(builder);
        this.createdAfter = builder.createdAfter;
        this.createdBefore = builder.createdBefore;
        this.clusterStates = builder.clusterStates;
        this.marker = builder.marker;
    }

    public Instant createdAfter() {
        return this.createdAfter;
    }

    public Instant createdBefore() {
        return this.createdBefore;
    }

    public List<ClusterState> clusterStates() {
        return TypeConverter.convert(this.clusterStates, ClusterState::fromValue);
    }

    public List<String> clusterStatesStrings() {
        return this.clusterStates;
    }

    public String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterStatesStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersRequest)) {
            return false;
        }
        ListClustersRequest other = (ListClustersRequest)((Object)obj);
        return Objects.equals(this.createdAfter(), other.createdAfter()) && Objects.equals(this.createdBefore(), other.createdBefore()) && Objects.equals(this.clusterStatesStrings(), other.clusterStatesStrings()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListClustersRequest").add("CreatedAfter", (Object)this.createdAfter()).add("CreatedBefore", (Object)this.createdBefore()).add("ClusterStates", this.clusterStatesStrings()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedAfter": {
                return Optional.of(clazz.cast(this.createdAfter()));
            }
            case "CreatedBefore": {
                return Optional.of(clazz.cast(this.createdBefore()));
            }
            case "ClusterStates": {
                return Optional.of(clazz.cast(this.clusterStatesStrings()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EMRRequest.BuilderImpl
    implements Builder {
        private Instant createdAfter;
        private Instant createdBefore;
        private List<String> clusterStates;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClustersRequest model) {
            this.createdAfter(model.createdAfter);
            this.createdBefore(model.createdBefore);
            this.clusterStates(model.clusterStates);
            this.marker(model.marker);
        }

        public final Instant getCreatedAfter() {
            return this.createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        public final Instant getCreatedBefore() {
            return this.createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        public final Collection<String> getClusterStates() {
            return this.clusterStates;
        }

        @Override
        public final Builder clusterStates(Collection<String> clusterStates) {
            this.clusterStates = ClusterStateListCopier.copy(clusterStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterStates(String ... clusterStates) {
            this.clusterStates(Arrays.asList(clusterStates));
            return this;
        }

        public final void setClusterStates(Collection<String> clusterStates) {
            this.clusterStates = ClusterStateListCopier.copy(clusterStates);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListClustersRequest build() {
            return new ListClustersRequest(this);
        }
    }

    public static interface Builder
    extends EMRRequest.Builder,
    CopyableBuilder<Builder, ListClustersRequest> {
        public Builder createdAfter(Instant var1);

        public Builder createdBefore(Instant var1);

        public Builder clusterStates(Collection<String> var1);

        public Builder clusterStates(String ... var1);

        public Builder marker(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

