/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.emr.model.EMRRequest;
import software.amazon.awssdk.services.emr.model.StepIdsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CancelStepsRequest
extends EMRRequest
implements ToCopyableBuilder<Builder, CancelStepsRequest> {
    private final String clusterId;
    private final List<String> stepIds;

    private CancelStepsRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.stepIds = builder.stepIds;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public List<String> stepIds() {
        return this.stepIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelStepsRequest)) {
            return false;
        }
        CancelStepsRequest other = (CancelStepsRequest)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.stepIds(), other.stepIds());
    }

    public String toString() {
        return ToString.builder((String)"CancelStepsRequest").add("ClusterId", (Object)this.clusterId()).add("StepIds", this.stepIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.of(clazz.cast(this.clusterId()));
            }
            case "StepIds": {
                return Optional.of(clazz.cast(this.stepIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EMRRequest.BuilderImpl
    implements Builder {
        private String clusterId;
        private List<String> stepIds;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelStepsRequest model) {
            this.clusterId(model.clusterId);
            this.stepIds(model.stepIds);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final Collection<String> getStepIds() {
            return this.stepIds;
        }

        @Override
        public final Builder stepIds(Collection<String> stepIds) {
            this.stepIds = StepIdsListCopier.copy(stepIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepIds(String ... stepIds) {
            this.stepIds(Arrays.asList(stepIds));
            return this;
        }

        public final void setStepIds(Collection<String> stepIds) {
            this.stepIds = StepIdsListCopier.copy(stepIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CancelStepsRequest build() {
            return new CancelStepsRequest(this);
        }
    }

    public static interface Builder
    extends EMRRequest.Builder,
    CopyableBuilder<Builder, CancelStepsRequest> {
        public Builder clusterId(String var1);

        public Builder stepIds(Collection<String> var1);

        public Builder stepIds(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

