/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.ScriptBootstrapActionConfig;
import software.amazon.awssdk.services.emr.transform.BootstrapActionConfigMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BootstrapActionConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, BootstrapActionConfig> {
    private final String name;
    private final ScriptBootstrapActionConfig scriptBootstrapAction;

    private BootstrapActionConfig(BuilderImpl builder) {
        this.name = builder.name;
        this.scriptBootstrapAction = builder.scriptBootstrapAction;
    }

    public String name() {
        return this.name;
    }

    public ScriptBootstrapActionConfig scriptBootstrapAction() {
        return this.scriptBootstrapAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptBootstrapAction());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BootstrapActionConfig)) {
            return false;
        }
        BootstrapActionConfig other = (BootstrapActionConfig)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.scriptBootstrapAction(), other.scriptBootstrapAction());
    }

    public String toString() {
        return ToString.builder((String)"BootstrapActionConfig").add("Name", (Object)this.name()).add("ScriptBootstrapAction", (Object)this.scriptBootstrapAction()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "ScriptBootstrapAction": {
                return Optional.of(clazz.cast(this.scriptBootstrapAction()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BootstrapActionConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private ScriptBootstrapActionConfig scriptBootstrapAction;

        private BuilderImpl() {
        }

        private BuilderImpl(BootstrapActionConfig model) {
            this.name(model.name);
            this.scriptBootstrapAction(model.scriptBootstrapAction);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ScriptBootstrapActionConfig.Builder getScriptBootstrapAction() {
            return this.scriptBootstrapAction != null ? this.scriptBootstrapAction.toBuilder() : null;
        }

        @Override
        public final Builder scriptBootstrapAction(ScriptBootstrapActionConfig scriptBootstrapAction) {
            this.scriptBootstrapAction = scriptBootstrapAction;
            return this;
        }

        public final void setScriptBootstrapAction(ScriptBootstrapActionConfig.BuilderImpl scriptBootstrapAction) {
            this.scriptBootstrapAction = scriptBootstrapAction != null ? scriptBootstrapAction.build() : null;
        }

        public BootstrapActionConfig build() {
            return new BootstrapActionConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BootstrapActionConfig> {
        public Builder name(String var1);

        public Builder scriptBootstrapAction(ScriptBootstrapActionConfig var1);

        default public Builder scriptBootstrapAction(Consumer<ScriptBootstrapActionConfig.Builder> scriptBootstrapAction) {
            return this.scriptBootstrapAction((ScriptBootstrapActionConfig)((ScriptBootstrapActionConfig.Builder)ScriptBootstrapActionConfig.builder().apply(scriptBootstrapAction)).build());
        }
    }
}

