/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.Protocol;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.emr.model.RunJobFlowRequest;
import software.amazon.awssdk.services.emr.transform.RunJobFlowRequestModelMarshaller;

@SdkInternalApi
public class RunJobFlowRequestMarshaller
implements Marshaller<Request<RunJobFlowRequest>, RunJobFlowRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().protocol(Protocol.AWS_JSON).requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("ElasticMapReduce.RunJobFlow").serviceName("EMRClient").build();
    private final SdkJsonProtocolFactory protocolFactory;

    public RunJobFlowRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<RunJobFlowRequest> marshall(RunJobFlowRequest runJobFlowRequest) {
        if (runJobFlowRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)runJobFlowRequest);
            protocolMarshaller.startMarshalling();
            RunJobFlowRequestModelMarshaller.getInstance().marshall(runJobFlowRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

