/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.CloudWatchAlarmDefinition;

@SdkInternalApi
public class CloudWatchAlarmDefinitionMarshaller {
    private static final MarshallingInfo<String> COMPARISONOPERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComparisonOperator").build();
    private static final MarshallingInfo<Integer> EVALUATIONPERIODS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EvaluationPeriods").build();
    private static final MarshallingInfo<String> METRICNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetricName").build();
    private static final MarshallingInfo<String> NAMESPACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Namespace").build();
    private static final MarshallingInfo<Integer> PERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Period").build();
    private static final MarshallingInfo<String> STATISTIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Statistic").build();
    private static final MarshallingInfo<Double> THRESHOLD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Threshold").build();
    private static final MarshallingInfo<String> UNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Unit").build();
    private static final MarshallingInfo<List> DIMENSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Dimensions").build();
    private static final CloudWatchAlarmDefinitionMarshaller INSTANCE = new CloudWatchAlarmDefinitionMarshaller();

    public static CloudWatchAlarmDefinitionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CloudWatchAlarmDefinition cloudWatchAlarmDefinition, ProtocolMarshaller protocolMarshaller) {
        if (cloudWatchAlarmDefinition == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cloudWatchAlarmDefinition.comparisonOperatorString(), COMPARISONOPERATOR_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchAlarmDefinition.evaluationPeriods(), EVALUATIONPERIODS_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchAlarmDefinition.metricName(), METRICNAME_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchAlarmDefinition.namespace(), NAMESPACE_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchAlarmDefinition.period(), PERIOD_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchAlarmDefinition.statisticString(), STATISTIC_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchAlarmDefinition.threshold(), THRESHOLD_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchAlarmDefinition.unitString(), UNIT_BINDING);
            protocolMarshaller.marshall(cloudWatchAlarmDefinition.dimensions(), DIMENSIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

