/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.emr.EMRClient;
import software.amazon.awssdk.services.emr.model.ClusterSummary;
import software.amazon.awssdk.services.emr.model.ListClustersRequest;
import software.amazon.awssdk.services.emr.model.ListClustersResponse;

public final class ListClustersPaginator
implements SdkIterable<ListClustersResponse> {
    private final EMRClient client;
    private final ListClustersRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListClustersPaginator(EMRClient client, ListClustersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListClustersResponseFetcher();
    }

    public Iterator<ListClustersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<ClusterSummary> clusters() {
        Function<ListClustersResponse, Iterator> getIterator = response -> response != null ? response.clusters().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListClustersResponseFetcher
    implements NextPageFetcher<ListClustersResponse> {
        private ListClustersResponseFetcher() {
        }

        public boolean hasNextPage(ListClustersResponse previousPage) {
            return previousPage.marker() != null;
        }

        public ListClustersResponse nextPage(ListClustersResponse previousPage) {
            if (previousPage == null) {
                return ListClustersPaginator.this.client.listClusters(ListClustersPaginator.this.firstRequest);
            }
            return ListClustersPaginator.this.client.listClusters((ListClustersRequest)((Object)ListClustersPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

