/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.emr.model.EMRRequest;
import software.amazon.awssdk.services.emr.model.XmlStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TerminateJobFlowsRequest
extends EMRRequest
implements ToCopyableBuilder<Builder, TerminateJobFlowsRequest> {
    private final List<String> jobFlowIds;

    private TerminateJobFlowsRequest(BuilderImpl builder) {
        super(builder);
        this.jobFlowIds = builder.jobFlowIds;
    }

    public List<String> jobFlowIds() {
        return this.jobFlowIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobFlowIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateJobFlowsRequest)) {
            return false;
        }
        TerminateJobFlowsRequest other = (TerminateJobFlowsRequest)((Object)obj);
        return Objects.equals(this.jobFlowIds(), other.jobFlowIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.jobFlowIds() != null) {
            sb.append("JobFlowIds: ").append(this.jobFlowIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobFlowIds": {
                return Optional.of(clazz.cast(this.jobFlowIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EMRRequest.BuilderImpl
    implements Builder {
        private List<String> jobFlowIds;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateJobFlowsRequest model) {
            this.jobFlowIds(model.jobFlowIds);
        }

        public final Collection<String> getJobFlowIds() {
            return this.jobFlowIds;
        }

        @Override
        public final Builder jobFlowIds(Collection<String> jobFlowIds) {
            this.jobFlowIds = XmlStringListCopier.copy(jobFlowIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobFlowIds(String ... jobFlowIds) {
            this.jobFlowIds(Arrays.asList(jobFlowIds));
            return this;
        }

        public final void setJobFlowIds(Collection<String> jobFlowIds) {
            this.jobFlowIds = XmlStringListCopier.copy(jobFlowIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public TerminateJobFlowsRequest build() {
            return new TerminateJobFlowsRequest(this);
        }
    }

    public static interface Builder
    extends EMRRequest.Builder,
    CopyableBuilder<Builder, TerminateJobFlowsRequest> {
        public Builder jobFlowIds(Collection<String> var1);

        public Builder jobFlowIds(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

