/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.emr.model.EMRRequest;
import software.amazon.awssdk.services.emr.model.StringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RemoveTagsRequest
extends EMRRequest
implements ToCopyableBuilder<Builder, RemoveTagsRequest> {
    private final String resourceId;
    private final List<String> tagKeys;

    private RemoveTagsRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.tagKeys = builder.tagKeys;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public List<String> tagKeys() {
        return this.tagKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagKeys());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveTagsRequest)) {
            return false;
        }
        RemoveTagsRequest other = (RemoveTagsRequest)((Object)obj);
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.tagKeys(), other.tagKeys());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (this.tagKeys() != null) {
            sb.append("TagKeys: ").append(this.tagKeys()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.of(clazz.cast(this.resourceId()));
            }
            case "TagKeys": {
                return Optional.of(clazz.cast(this.tagKeys()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EMRRequest.BuilderImpl
    implements Builder {
        private String resourceId;
        private List<String> tagKeys;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveTagsRequest model) {
            this.resourceId(model.resourceId);
            this.tagKeys(model.tagKeys);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Collection<String> getTagKeys() {
            return this.tagKeys;
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = StringListCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String ... tagKeys) {
            this.tagKeys(Arrays.asList(tagKeys));
            return this;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = StringListCopier.copy(tagKeys);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RemoveTagsRequest build() {
            return new RemoveTagsRequest(this);
        }
    }

    public static interface Builder
    extends EMRRequest.Builder,
    CopyableBuilder<Builder, RemoveTagsRequest> {
        public Builder resourceId(String var1);

        public Builder tagKeys(Collection<String> var1);

        public Builder tagKeys(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

