/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.emr.model.EMRRequest;
import software.amazon.awssdk.services.emr.model.InstanceGroupConfig;
import software.amazon.awssdk.services.emr.model.InstanceGroupConfigListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddInstanceGroupsRequest
extends EMRRequest
implements ToCopyableBuilder<Builder, AddInstanceGroupsRequest> {
    private final List<InstanceGroupConfig> instanceGroups;
    private final String jobFlowId;

    private AddInstanceGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceGroups = builder.instanceGroups;
        this.jobFlowId = builder.jobFlowId;
    }

    public List<InstanceGroupConfig> instanceGroups() {
        return this.instanceGroups;
    }

    public String jobFlowId() {
        return this.jobFlowId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobFlowId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddInstanceGroupsRequest)) {
            return false;
        }
        AddInstanceGroupsRequest other = (AddInstanceGroupsRequest)((Object)obj);
        return Objects.equals(this.instanceGroups(), other.instanceGroups()) && Objects.equals(this.jobFlowId(), other.jobFlowId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceGroups() != null) {
            sb.append("InstanceGroups: ").append(this.instanceGroups()).append(",");
        }
        if (this.jobFlowId() != null) {
            sb.append("JobFlowId: ").append(this.jobFlowId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceGroups": {
                return Optional.of(clazz.cast(this.instanceGroups()));
            }
            case "JobFlowId": {
                return Optional.of(clazz.cast(this.jobFlowId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EMRRequest.BuilderImpl
    implements Builder {
        private List<InstanceGroupConfig> instanceGroups;
        private String jobFlowId;

        private BuilderImpl() {
        }

        private BuilderImpl(AddInstanceGroupsRequest model) {
            this.instanceGroups(model.instanceGroups);
            this.jobFlowId(model.jobFlowId);
        }

        public final Collection<InstanceGroupConfig.Builder> getInstanceGroups() {
            return this.instanceGroups != null ? (Collection)this.instanceGroups.stream().map(InstanceGroupConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceGroups(Collection<InstanceGroupConfig> instanceGroups) {
            this.instanceGroups = InstanceGroupConfigListCopier.copy(instanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(InstanceGroupConfig ... instanceGroups) {
            this.instanceGroups(Arrays.asList(instanceGroups));
            return this;
        }

        public final void setInstanceGroups(Collection<InstanceGroupConfig.BuilderImpl> instanceGroups) {
            this.instanceGroups = InstanceGroupConfigListCopier.copyFromBuilder(instanceGroups);
        }

        public final String getJobFlowId() {
            return this.jobFlowId;
        }

        @Override
        public final Builder jobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
            return this;
        }

        public final void setJobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AddInstanceGroupsRequest build() {
            return new AddInstanceGroupsRequest(this);
        }
    }

    public static interface Builder
    extends EMRRequest.Builder,
    CopyableBuilder<Builder, AddInstanceGroupsRequest> {
        public Builder instanceGroups(Collection<InstanceGroupConfig> var1);

        public Builder instanceGroups(InstanceGroupConfig ... var1);

        public Builder jobFlowId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

