/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.emr.model.InstanceGroupModifyConfig;
import software.amazon.awssdk.services.emr.model.InstanceGroupModifyConfigListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyInstanceGroupsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyInstanceGroupsRequest> {
    private final String clusterId;
    private final List<InstanceGroupModifyConfig> instanceGroups;

    private ModifyInstanceGroupsRequest(BuilderImpl builder) {
        this.clusterId = builder.clusterId;
        this.instanceGroups = builder.instanceGroups;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public List<InstanceGroupModifyConfig> instanceGroups() {
        return this.instanceGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceGroupsRequest)) {
            return false;
        }
        ModifyInstanceGroupsRequest other = (ModifyInstanceGroupsRequest)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.instanceGroups(), other.instanceGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.clusterId() != null) {
            sb.append("ClusterId: ").append(this.clusterId()).append(",");
        }
        if (this.instanceGroups() != null) {
            sb.append("InstanceGroups: ").append(this.instanceGroups()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.of(clazz.cast(this.clusterId()));
            }
            case "InstanceGroups": {
                return Optional.of(clazz.cast(this.instanceGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterId;
        private List<InstanceGroupModifyConfig> instanceGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceGroupsRequest model) {
            this.clusterId(model.clusterId);
            this.instanceGroups(model.instanceGroups);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final Collection<InstanceGroupModifyConfig.Builder> getInstanceGroups() {
            return this.instanceGroups != null ? (Collection)this.instanceGroups.stream().map(InstanceGroupModifyConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceGroups(Collection<InstanceGroupModifyConfig> instanceGroups) {
            this.instanceGroups = InstanceGroupModifyConfigListCopier.copy(instanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(InstanceGroupModifyConfig ... instanceGroups) {
            this.instanceGroups(Arrays.asList(instanceGroups));
            return this;
        }

        public final void setInstanceGroups(Collection<InstanceGroupModifyConfig.BuilderImpl> instanceGroups) {
            this.instanceGroups = InstanceGroupModifyConfigListCopier.copyFromBuilder(instanceGroups);
        }

        public ModifyInstanceGroupsRequest build() {
            return new ModifyInstanceGroupsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyInstanceGroupsRequest> {
        public Builder clusterId(String var1);

        public Builder instanceGroups(Collection<InstanceGroupModifyConfig> var1);

        public Builder instanceGroups(InstanceGroupModifyConfig ... var1);
    }
}

