/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.emr.model.InstanceFleetModifyConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyInstanceFleetRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyInstanceFleetRequest> {
    private final String clusterId;
    private final InstanceFleetModifyConfig instanceFleet;

    private ModifyInstanceFleetRequest(BuilderImpl builder) {
        this.clusterId = builder.clusterId;
        this.instanceFleet = builder.instanceFleet;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public InstanceFleetModifyConfig instanceFleet() {
        return this.instanceFleet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFleet());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceFleetRequest)) {
            return false;
        }
        ModifyInstanceFleetRequest other = (ModifyInstanceFleetRequest)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.instanceFleet(), other.instanceFleet());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.clusterId() != null) {
            sb.append("ClusterId: ").append(this.clusterId()).append(",");
        }
        if (this.instanceFleet() != null) {
            sb.append("InstanceFleet: ").append(this.instanceFleet()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.of(clazz.cast(this.clusterId()));
            }
            case "InstanceFleet": {
                return Optional.of(clazz.cast(this.instanceFleet()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterId;
        private InstanceFleetModifyConfig instanceFleet;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceFleetRequest model) {
            this.clusterId(model.clusterId);
            this.instanceFleet(model.instanceFleet);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final InstanceFleetModifyConfig.Builder getInstanceFleet() {
            return this.instanceFleet != null ? this.instanceFleet.toBuilder() : null;
        }

        @Override
        public final Builder instanceFleet(InstanceFleetModifyConfig instanceFleet) {
            this.instanceFleet = instanceFleet;
            return this;
        }

        public final void setInstanceFleet(InstanceFleetModifyConfig.BuilderImpl instanceFleet) {
            this.instanceFleet = instanceFleet != null ? instanceFleet.build() : null;
        }

        public ModifyInstanceFleetRequest build() {
            return new ModifyInstanceFleetRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyInstanceFleetRequest> {
        public Builder clusterId(String var1);

        public Builder instanceFleet(InstanceFleetModifyConfig var1);

        default public Builder instanceFleet(Consumer<InstanceFleetModifyConfig.Builder> instanceFleet) {
            return this.instanceFleet((InstanceFleetModifyConfig)((InstanceFleetModifyConfig.Builder)InstanceFleetModifyConfig.builder().apply(instanceFleet)).build());
        }
    }
}

