/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.EC2InstanceIdsToTerminateListCopier;
import software.amazon.awssdk.services.emr.model.ShrinkPolicy;
import software.amazon.awssdk.services.emr.transform.InstanceGroupModifyConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceGroupModifyConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceGroupModifyConfig> {
    private final String instanceGroupId;
    private final Integer instanceCount;
    private final List<String> ec2InstanceIdsToTerminate;
    private final ShrinkPolicy shrinkPolicy;

    private InstanceGroupModifyConfig(BuilderImpl builder) {
        this.instanceGroupId = builder.instanceGroupId;
        this.instanceCount = builder.instanceCount;
        this.ec2InstanceIdsToTerminate = builder.ec2InstanceIdsToTerminate;
        this.shrinkPolicy = builder.shrinkPolicy;
    }

    public String instanceGroupId() {
        return this.instanceGroupId;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public List<String> ec2InstanceIdsToTerminate() {
        return this.ec2InstanceIdsToTerminate;
    }

    public ShrinkPolicy shrinkPolicy() {
        return this.shrinkPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceIdsToTerminate());
        hashCode = 31 * hashCode + Objects.hashCode(this.shrinkPolicy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceGroupModifyConfig)) {
            return false;
        }
        InstanceGroupModifyConfig other = (InstanceGroupModifyConfig)obj;
        return Objects.equals(this.instanceGroupId(), other.instanceGroupId()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.ec2InstanceIdsToTerminate(), other.ec2InstanceIdsToTerminate()) && Objects.equals(this.shrinkPolicy(), other.shrinkPolicy());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceGroupId() != null) {
            sb.append("InstanceGroupId: ").append(this.instanceGroupId()).append(",");
        }
        if (this.instanceCount() != null) {
            sb.append("InstanceCount: ").append(this.instanceCount()).append(",");
        }
        if (this.ec2InstanceIdsToTerminate() != null) {
            sb.append("EC2InstanceIdsToTerminate: ").append(this.ec2InstanceIdsToTerminate()).append(",");
        }
        if (this.shrinkPolicy() != null) {
            sb.append("ShrinkPolicy: ").append(this.shrinkPolicy()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceGroupId": {
                return Optional.of(clazz.cast(this.instanceGroupId()));
            }
            case "InstanceCount": {
                return Optional.of(clazz.cast(this.instanceCount()));
            }
            case "EC2InstanceIdsToTerminate": {
                return Optional.of(clazz.cast(this.ec2InstanceIdsToTerminate()));
            }
            case "ShrinkPolicy": {
                return Optional.of(clazz.cast(this.shrinkPolicy()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceGroupModifyConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceGroupId;
        private Integer instanceCount;
        private List<String> ec2InstanceIdsToTerminate;
        private ShrinkPolicy shrinkPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceGroupModifyConfig model) {
            this.instanceGroupId(model.instanceGroupId);
            this.instanceCount(model.instanceCount);
            this.ec2InstanceIdsToTerminate(model.ec2InstanceIdsToTerminate);
            this.shrinkPolicy(model.shrinkPolicy);
        }

        public final String getInstanceGroupId() {
            return this.instanceGroupId;
        }

        @Override
        public final Builder instanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
            return this;
        }

        public final void setInstanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final Collection<String> getEC2InstanceIdsToTerminate() {
            return this.ec2InstanceIdsToTerminate;
        }

        @Override
        public final Builder ec2InstanceIdsToTerminate(Collection<String> ec2InstanceIdsToTerminate) {
            this.ec2InstanceIdsToTerminate = EC2InstanceIdsToTerminateListCopier.copy(ec2InstanceIdsToTerminate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceIdsToTerminate(String ... ec2InstanceIdsToTerminate) {
            this.ec2InstanceIdsToTerminate(Arrays.asList(ec2InstanceIdsToTerminate));
            return this;
        }

        public final void setEC2InstanceIdsToTerminate(Collection<String> ec2InstanceIdsToTerminate) {
            this.ec2InstanceIdsToTerminate = EC2InstanceIdsToTerminateListCopier.copy(ec2InstanceIdsToTerminate);
        }

        public final ShrinkPolicy.Builder getShrinkPolicy() {
            return this.shrinkPolicy != null ? this.shrinkPolicy.toBuilder() : null;
        }

        @Override
        public final Builder shrinkPolicy(ShrinkPolicy shrinkPolicy) {
            this.shrinkPolicy = shrinkPolicy;
            return this;
        }

        public final void setShrinkPolicy(ShrinkPolicy.BuilderImpl shrinkPolicy) {
            this.shrinkPolicy = shrinkPolicy != null ? shrinkPolicy.build() : null;
        }

        public InstanceGroupModifyConfig build() {
            return new InstanceGroupModifyConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceGroupModifyConfig> {
        public Builder instanceGroupId(String var1);

        public Builder instanceCount(Integer var1);

        public Builder ec2InstanceIdsToTerminate(Collection<String> var1);

        public Builder ec2InstanceIdsToTerminate(String ... var1);

        public Builder shrinkPolicy(ShrinkPolicy var1);

        default public Builder shrinkPolicy(Consumer<ShrinkPolicy.Builder> shrinkPolicy) {
            return this.shrinkPolicy((ShrinkPolicy)((ShrinkPolicy.Builder)ShrinkPolicy.builder().apply(shrinkPolicy)).build());
        }
    }
}

