/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateSecurityConfigurationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateSecurityConfigurationRequest> {
    private final String name;
    private final String securityConfiguration;

    private CreateSecurityConfigurationRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.securityConfiguration = builder.securityConfiguration;
    }

    public String name() {
        return this.name;
    }

    public String securityConfiguration() {
        return this.securityConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSecurityConfigurationRequest)) {
            return false;
        }
        CreateSecurityConfigurationRequest other = (CreateSecurityConfigurationRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.securityConfiguration(), other.securityConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.securityConfiguration() != null) {
            sb.append("SecurityConfiguration: ").append(this.securityConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "SecurityConfiguration": {
                return Optional.of(clazz.cast(this.securityConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String securityConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSecurityConfigurationRequest model) {
            this.name(model.name);
            this.securityConfiguration(model.securityConfiguration);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        public CreateSecurityConfigurationRequest build() {
            return new CreateSecurityConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateSecurityConfigurationRequest> {
        public Builder name(String var1);

        public Builder securityConfiguration(String var1);
    }
}

