/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.emr.model.VolumeSpecification;

public class VolumeSpecificationUnmarshaller
implements Unmarshaller<VolumeSpecification, JsonUnmarshallerContext> {
    private static final VolumeSpecificationUnmarshaller INSTANCE = new VolumeSpecificationUnmarshaller();

    public VolumeSpecification unmarshall(JsonUnmarshallerContext context) throws Exception {
        VolumeSpecification.Builder volumeSpecificationBuilder = VolumeSpecification.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("VolumeType", targetDepth)) {
                    context.nextToken();
                    volumeSpecificationBuilder.volumeType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Iops", targetDepth)) {
                    context.nextToken();
                    volumeSpecificationBuilder.iops((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("SizeInGB", targetDepth)) {
                    context.nextToken();
                    volumeSpecificationBuilder.sizeInGB((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (VolumeSpecification)volumeSpecificationBuilder.build();
    }

    public static VolumeSpecificationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

