/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.StepConfig;

@SdkInternalApi
public class StepConfigMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> ACTIONONFAILURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActionOnFailure").build();
    private static final MarshallingInfo<StructuredPojo> HADOOPJARSTEP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HadoopJarStep").build();
    private static final StepConfigMarshaller INSTANCE = new StepConfigMarshaller();

    public static StepConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StepConfig stepConfig, ProtocolMarshaller protocolMarshaller) {
        if (stepConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)stepConfig.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)stepConfig.actionOnFailureString(), ACTIONONFAILURE_BINDING);
            protocolMarshaller.marshall((Object)stepConfig.hadoopJarStep(), HADOOPJARSTEP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

